/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.render.multiblock;

import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import flaxbeard.immersivepetroleum.client.render.IPRenderTypes;
import flaxbeard.immersivepetroleum.client.render.multiblock.Face;
import flaxbeard.immersivepetroleum.client.render.multiblock.IPMultiblockRenderer;
import flaxbeard.immersivepetroleum.client.render.multiblock.QuickDraw;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.DistillationTowerMultiblock;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.distillation_tower.DistillationTowerLogic;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MultiblockDistillationTowerRenderer
extends IPMultiblockRenderer<DistillationTowerLogic.State> {
    static final Face ACTIVE_BOILER_SIDE = Face.of(0, 0, 16, 24);
    static final Face ACTIVE_BOILER_FRONT = Face.of(16, 0, 32, 24);
    static final Face ACTIVE_BOILER_BACK = Face.of(16, 24, 32, 24);

    public MultiblockDistillationTowerRenderer() {
        super(() -> DistillationTowerMultiblock.INSTANCE);
    }

    public void render(@Nonnull MultiblockBlockEntityMaster<DistillationTowerLogic.State> te, float partialTicks, @Nonnull PoseStack transform, @Nonnull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (te.isRemoved() || te.getLevel() == null || !te.getLevel().hasChunkAt(te.getBlockPos())) {
            return;
        }
        if (((DistillationTowerLogic.State)te.getHelper().getState()).cooldownTicks <= 0) {
            return;
        }
        combinedOverlayIn = OverlayTexture.NO_OVERLAY;
        transform.pushPose();
        Direction rotation = te.getHelper().getContext().getLevel().getOrientation().front();
        switch (rotation) {
            case NORTH: {
                transform.translate(3.0f, 0.0f, 4.0f);
                break;
            }
            case SOUTH: {
                transform.mulPose(ROT_180);
                transform.translate(2.0f, 0.0f, 3.0f);
                break;
            }
            case EAST: {
                transform.mulPose(ROT_270);
                transform.translate(3.0f, 0.0f, 3.0f);
                break;
            }
            case WEST: {
                transform.mulPose(ROT_90);
                transform.translate(2.0f, 0.0f, 4.0f);
                break;
            }
        }
        VertexConsumer buf = bufferIn.getBuffer(IPRenderTypes.DISTILLATION_TOWER_ACTIVE_OVERLAY);
        if (te.getHelper().getContext().getLevel().getOrientation().mirrored()) {
            transform.pushPose();
            transform.translate(-4.0, 0.0, -4.0);
            QuickDraw draw = new QuickDraw(buf, transform, -1, combinedOverlayIn, 0xF000F0);
            Face face0 = ACTIVE_BOILER_FRONT;
            draw.vertex(-0.0015f, 0.5f, face0.w16(), face0.u1(), face0.v1());
            draw.vertex(-0.0015f, 0.5f + face0.h16(), face0.w16(), face0.u1(), face0.v0());
            draw.vertex(-0.0015f, 0.5f + face0.h16(), 0.0f, face0.u0(), face0.v0());
            draw.vertex(-0.0015f, 0.5f, 0.0f, face0.u0(), face0.v1());
            Face face1 = ACTIVE_BOILER_BACK;
            draw.vertex(1.0015f, 0.5f + face1.h16(), 0.0f, face1.u1(), face1.v0());
            draw.vertex(1.0015f, 0.5f + face1.h16(), face1.w16(), face1.u0(), face1.v0());
            draw.vertex(1.0015f, 0.5f, face1.w16(), face1.u0(), face1.v1());
            draw.vertex(1.0015f, 0.5f, 0.0f, face1.u1(), face1.v1());
            Face face2 = ACTIVE_BOILER_SIDE;
            draw.vertex(face2.w16(), 0.5f, 2.0015f, face2.u1(), face2.v1());
            draw.vertex(face2.w16(), 0.5f + face2.h16(), 2.0015f, face2.u1(), face2.v0());
            draw.vertex(0.0f, 0.5f + face2.h16(), 2.0015f, face2.u0(), face2.v0());
            draw.vertex(0.0f, 0.5f, 2.0015f, face2.u0(), face2.v1());
            transform.popPose();
        } else {
            transform.pushPose();
            transform.translate(-2.0, 0.0, -4.0);
            QuickDraw draw = new QuickDraw(buf, transform, -1, combinedOverlayIn, 0xF000F0);
            Face face1 = ACTIVE_BOILER_FRONT;
            draw.vertex(1.0015f, 0.5f + face1.h16(), 0.0f, face1.u0(), face1.v0());
            draw.vertex(1.0015f, 0.5f + face1.h16(), face1.w16(), face1.u1(), face1.v0());
            draw.vertex(1.0015f, 0.5f, face1.w16(), face1.u1(), face1.v1());
            draw.vertex(1.0015f, 0.5f, 0.0f, face1.u0(), face1.v1());
            Face face0 = ACTIVE_BOILER_BACK;
            draw.vertex(-0.0015f, 0.5f, face0.w16(), face0.u0(), face0.v1());
            draw.vertex(-0.0015f, 0.5f + face0.h16(), face0.w16(), face0.u0(), face0.v0());
            draw.vertex(-0.0015f, 0.5f + face0.h16(), 0.0f, face0.u1(), face0.v0());
            draw.vertex(-0.0015f, 0.5f, 0.0f, face0.u1(), face0.v1());
            Face face2 = ACTIVE_BOILER_SIDE;
            draw.vertex(face2.w16(), 0.5f, 2.0015f, face2.u0(), face2.v1());
            draw.vertex(face2.w16(), 0.5f + face2.h16(), 2.0015f, face2.u0(), face2.v0());
            draw.vertex(0.0f, 0.5f + face2.h16(), 2.0015f, face2.u1(), face2.v0());
            draw.vertex(0.0f, 0.5f, 2.0015f, face2.u1(), face2.v1());
            transform.popPose();
        }
        transform.popPose();
    }
}

