/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.model;

import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.client.model.IPModel;
import flaxbeard.immersivepetroleum.client.model.ModelLubricantPipes;
import flaxbeard.immersivepetroleum.client.model.ModelPumpjack;
import flaxbeard.immersivepetroleum.client.render.BlockSeismicSurveyBarrelRenderer;
import flaxbeard.immersivepetroleum.client.render.multiblock.MultiblockDerrickRenderer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLConstructModEvent;
import net.neoforged.neoforge.client.event.ModelEvent;

@EventBusSubscriber(modid="immersivepetroleum", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class IPModels {
    private static final Map<String, IPModel> MODELS = new HashMap<String, IPModel>();

    @SubscribeEvent
    public static void init(FMLConstructModEvent event) {
        IPModels.add("pumpjackarm", new ModelPumpjack());
        IPModels.add("crusher_lubepipes", new ModelLubricantPipes.Crusher());
        IPModels.add("excavator_lubepipes_normal", new ModelLubricantPipes.Excavator(false));
        IPModels.add("excavator_lubepipes_mirrored", new ModelLubricantPipes.Excavator(true));
        IPModels.add("pumpjack_lubepipes_normal", new ModelLubricantPipes.Pumpjack(false));
        IPModels.add("pumpjack_lubepipes_mirrored", new ModelLubricantPipes.Pumpjack(true));
    }

    @SubscribeEvent
    public static void registerDynamicOBJModels(ModelEvent.RegisterAdditional event) {
        event.register(BlockSeismicSurveyBarrelRenderer.BARREL);
        event.register(MultiblockDerrickRenderer.DRILL);
        event.register(MultiblockDerrickRenderer.PIPE_SEGMENT);
        event.register(MultiblockDerrickRenderer.PIPE_TOP);
    }

    public static void add(String id, IPModel model) {
        if (MODELS.containsKey(id)) {
            ImmersivePetroleum.log.error("Duplicate ID, \"{}\" already used by {}. Skipping.", (Object)id, ((Object)((Object)MODELS.get(id))).getClass());
        } else {
            model.init();
            MODELS.put(id, model);
        }
    }

    public static Supplier<IPModel> getSupplier(String id) {
        return () -> MODELS.get(id);
    }

    public static Collection<IPModel> getModels() {
        return Collections.unmodifiableCollection(MODELS.values());
    }
}

