/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.gui.machines;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import flaxbeard.immersivepetroleum.client.gui.IPContainerScreen;
import flaxbeard.immersivepetroleum.client.gui.displays.Display;
import flaxbeard.immersivepetroleum.client.gui.displays.DisplayBounds;
import flaxbeard.immersivepetroleum.client.gui.displays.EnergyDisplay;
import flaxbeard.immersivepetroleum.client.gui.displays.FluidDisplay;
import flaxbeard.immersivepetroleum.client.gui.displays.parts.ItemParts;
import flaxbeard.immersivepetroleum.client.gui.machines.IPContainerScreen_DerrickSettingsScreen;
import flaxbeard.immersivepetroleum.common.ExternalModContent;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.DerrickLogic;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.WellTileEntity;
import flaxbeard.immersivepetroleum.common.cfg.IPClientConfig;
import flaxbeard.immersivepetroleum.common.cfg.IPServerConfig;
import flaxbeard.immersivepetroleum.common.gui.DerrickContainer;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import flaxbeard.immersivepetroleum.common.util.Utils;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;

public class IPContainerScreen_Derrick
extends IPContainerScreen<DerrickContainer> {
    static final ResourceLocation GUI_TEXTURE = ResourceUtils.ip("textures/gui/derrick.png");
    private Button cfgButton;

    public IPContainerScreen_Derrick(DerrickContainer container, Inventory inventory, Component title) {
        super(container, inventory, title, GUI_TEXTURE, 200, 172);
    }

    @Override
    protected void init() {
        super.init();
        MutableComponent inTankName = Component.translatable((String)"gui.immersivepetroleum.tank.input").withStyle(ChatFormatting.AQUA);
        this.addDisplay(FluidDisplay.create(this.leftPos + 8, this.topPos + 8, (Component)inTankName, ((DerrickContainer)this.getMenu()).tank));
        this.addDisplay(new ItemParts.PipeItemSlot(this.leftPos + 36, this.topPos + 26));
        this.addDisplay(new EnergyDisplay.Normal(this.leftPos + 181, this.topPos + 31, ((DerrickContainer)this.getMenu()).energy));
        this.addDisplay(new StatusConsole(this.leftPos + 60, this.topPos + 8, 0, this));
        this.cfgButton = new Button.Builder((Component)Component.translatable((String)"gui.immersivepetroleum.derrick.msg.config"), button -> this.minecraft.setScreen((Screen)new IPContainerScreen_DerrickSettingsScreen(this))).bounds(this.leftPos + 8, this.topPos + 61, 50, 20).build();
        this.addRenderableWidget((GuiEventListener)this.cfgButton);
    }

    private static class StatusConsole
    extends Display {
        protected static final ResourceLocation BOX = ResourceUtils.ip("text_box");
        final Font font;
        final IPContainerScreen_Derrick derrickScreen;
        final DerrickContainer container;
        final Console console = new Console(7);

        public StatusConsole(int x, int y, int depth, IPContainerScreen_Derrick derrickScreen) {
            super(DisplayBounds.of(x, y, 120, 73), depth);
            this.derrickScreen = derrickScreen;
            this.font = derrickScreen.font;
            this.container = (DerrickContainer)derrickScreen.getMenu();
        }

        @Override
        protected void tooltip(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, List<Component> tooltip) {
            tooltip.add((Component)Component.translatable((String)"gui.immersivepetroleum.derrick.status_console.desc").withStyle(ChatFormatting.GRAY));
        }

        @Override
        public void draw(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY) {
            guiGraphics.blitSprite(BOX, this.bounds.x0(), this.bounds.y0(), 0, this.bounds.width(), this.bounds.height());
            if (this.container.pos().getY() <= 62) {
                this.console.belowWaterTableText();
            } else {
                Object object;
                IMultiblockBE multiblockBE;
                IMultiblockContext context;
                BlockEntity tile = this.container.level.getBlockEntity(this.container.pos());
                if (tile instanceof IMultiblockBE && (context = (multiblockBE = (IMultiblockBE)tile).getHelper().getContext()) != null && (object = context.getState()) instanceof DerrickLogic.State) {
                    DerrickLogic.State state = (DerrickLogic.State)object;
                    IMultiblockLevel level = context.getLevel();
                    if (state.isRedstoned) {
                        this.console.disabledText();
                    } else {
                        this.updateStatusConsole(this.console, state, level);
                    }
                }
            }
            this.console.forEachLine((lineIndex, alignment, text, color) -> this.drawConsoleText(guiGraphics, lineIndex, alignment, text, color));
        }

        private void updateStatusConsole(Console console, DerrickLogic.State state, IMultiblockLevel mbLevel) {
            WellTileEntity well = state.getWell(mbLevel, mbLevel.toAbsolute(IPContent.Multiblock.DERRICK.masterPosInMB()));
            if (well != null) {
                if (this.derrickScreen.cfgButton.active && well.wellPipeLength > 0) {
                    this.derrickScreen.cfgButton.active = false;
                    this.derrickScreen.cfgButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.immersivepetroleum.derrick.msg.set_in_stone")));
                }
                if (well.wellPipeLength < well.getMaxPipeLength()) {
                    if (state.drilling) {
                        String str = String.format(Locale.ROOT, "(%d%%)", (int)((float)(100 * well.wellPipeLength) / (float)well.getMaxPipeLength()));
                        console.addCenter((Component)Component.translatable((String)"gui.immersivepetroleum.derrick.msg.drilling", (Object[])new Object[]{str}), IPClientConfig.DERRICK_CONSOLE.getTextColorNormal());
                    } else {
                        if (well.pipes <= 0 && !this.container.getSlot(0).hasItem()) {
                            console.addLeft((Component)Component.translatable((String)"gui.immersivepetroleum.derrick.msg.out_of_pipes"), IPClientConfig.DERRICK_CONSOLE.getTextColorNormal());
                        }
                        if (this.container.energy.getEnergyStored() < (Integer)IPServerConfig.EXTRACTION.derrick_consumption.get()) {
                            console.addLeft((Component)Component.translatable((String)"gui.immersivepetroleum.derrick.msg.not_enough_power"), IPClientConfig.DERRICK_CONSOLE.getTextColorNormal());
                        }
                        if (this.container.tank.getFluid().isEmpty()) {
                            int realPipeLength = mbLevel.getAbsoluteOrigin().getY() - 1 - well.getBlockPos().getY();
                            int concreteNeeded = 125 * (realPipeLength - well.wellPipeLength);
                            if (concreteNeeded > 0) {
                                console.missingFluidText(ExternalModContent.IE.fluidConcrete(), concreteNeeded);
                            } else {
                                int waterNeeded = 125 * (well.getMaxPipeLength() - well.wellPipeLength);
                                if (waterNeeded > 0) {
                                    console.missingFluidText((Fluid)Fluids.WATER, waterNeeded);
                                }
                            }
                        }
                    }
                } else if (state.spilling) {
                    console.safetyValveOpenText();
                } else {
                    console.completedText();
                }
            }
        }

        private void drawConsoleText(@Nonnull GuiGraphics guiGraphics, int line, Console.Alignment alignment, Component text, int color) {
            int strWidth = this.font.width(text.getString());
            int x = this.bounds.x0() + 3;
            int y = this.bounds.y0() + 3 + 10 * line;
            switch (alignment.ordinal()) {
                case 1: {
                    float cX = (float)(this.bounds.x0() + this.bounds.x1()) / 2.0f;
                    x = (int)(cX - (float)strWidth / 2.0f);
                    break;
                }
                case 2: {
                    x = this.bounds.x1() - 3 - strWidth;
                }
            }
            this.drawString(guiGraphics, text, x, y, color);
        }

        private void drawString(@Nonnull GuiGraphics guiGraphics, Component text, int x, int y, int color) {
            if (IPClientConfig.DERRICK_CONSOLE.useOldSchool()) {
                guiGraphics.drawString(this.font, text, x, y, color);
            } else {
                for (int j = -1; j <= 1; ++j) {
                    for (int i = -1; i <= 1; ++i) {
                        if (i == 0 && j == 0) continue;
                        guiGraphics.drawString(this.font, text, x + i, y + j, -16777216, false);
                    }
                }
                guiGraphics.drawString(this.font, text, x, y, color, false);
            }
        }

        static class Console {
            private final Line[] lines;

            Console(int maxLines) {
                this.lines = new Line[maxLines];
            }

            public void missingFluidText(Fluid fluid, int amount) {
                int color = IPClientConfig.DERRICK_CONSOLE.getTextColorNormal();
                this.addLeft((Component)Component.translatable((String)"gui.immersivepetroleum.derrick.msg.missing", (Object[])new Object[]{Utils.fDecimal(amount) + "mB"}), color);
                this.addLeft(new FluidStack(fluid, 1).getHoverName(), color);
            }

            public void belowWaterTableText() {
                int color = IPClientConfig.DERRICK_CONSOLE.getTextColorError();
                this.addMultiline(Alignment.CENTER, I18n.get((String)"gui.immersivepetroleum.derrick.msg.water_table", (Object[])new Object[0]), color);
                this.addEmpty();
            }

            public void safetyValveOpenText() {
                int color = IPClientConfig.DERRICK_CONSOLE.getTextColorError();
                this.addMultiline(Alignment.CENTER, I18n.get((String)"gui.immersivepetroleum.derrick.msg.safety_valve", (Object[])new Object[0]), color);
                this.addEmpty();
            }

            public void completedText() {
                int color = IPClientConfig.DERRICK_CONSOLE.getTextColorNormal();
                this.addMultiline(Alignment.CENTER, I18n.get((String)"gui.immersivepetroleum.derrick.msg.completed", (Object[])new Object[0]), color);
                this.addEmpty();
            }

            public void disabledText() {
                int color = IPClientConfig.DERRICK_CONSOLE.getTextColorError();
                this.addLeft((Component)Component.translatable((String)"gui.immersivepetroleum.derrick.msg.disabled"), color);
            }

            public void addMultiline(Alignment alignment, String str, int color) {
                String[] lines = str.split("<br>");
                for (int i = Math.min(lines.length, this.lines.length) - 1; i >= 0; --i) {
                    String line = lines[i];
                    this.add(alignment, (Component)Component.literal((String)(line.length() > 25 ? line.substring(0, 25) : line)), color);
                }
            }

            public void addEmpty() {
                this.add(null);
            }

            public void addLeft(Component text, int color) {
                this.add(Alignment.LEFT, text, color);
            }

            public void addCenter(Component text, int color) {
                this.add(Alignment.CENTER, text, color);
            }

            public void addRight(Component text, int color) {
                this.add(Alignment.RIGHT, text, color);
            }

            private void add(Alignment alignment, Component text, int color) {
                this.add(new Line(alignment, text, color));
            }

            private void add(Line line) {
                for (int i = 1; i < this.lines.length; ++i) {
                    this.lines[i - 1] = this.lines[i];
                }
                this.lines[this.lines.length - 1] = line;
            }

            public int getLineCount() {
                return this.lines.length;
            }

            public void forEachLine(Processor consumer) {
                int len = this.lines.length;
                for (int i = 0; i < len; ++i) {
                    Line line = this.lines[i];
                    if (line == null) continue;
                    consumer.process(len - i - 1, line.alignment, line.text, line.color);
                }
                this.clear();
            }

            private void clear() {
                Arrays.fill(this.lines, null);
            }

            record Line(Alignment alignment, Component text, int color) {
            }

            static enum Alignment {
                LEFT,
                CENTER,
                RIGHT;

            }

            @FunctionalInterface
            static interface Processor {
                public void process(int var1, Alignment var2, Component var3, int var4);
            }
        }
    }
}

