/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.gui.displays;

import blusunrize.immersiveengineering.common.fluids.PotionFluid;
import flaxbeard.immersivepetroleum.client.gui.displays.Display;
import flaxbeard.immersivepetroleum.client.gui.displays.DisplayBounds;
import flaxbeard.immersivepetroleum.client.gui.displays.TexCoords;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import java.util.List;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidDisplay
extends Display {
    private final IFluidTank tank;
    private final TexCoords tankBackground;
    private final TexCoords tankOverlay;
    @Nullable
    private final Component name;
    private final DisplayBounds fluidBounds;

    public static FluidDisplay create(int x, int y, @Nonnull IFluidTank tank) {
        return FluidDisplay.create(x, y, null, tank);
    }

    public static FluidDisplay create(int x, int y, @Nullable Component name, @Nonnull IFluidTank tank) {
        return new FluidDisplay(x, y, new TexCoords(0, 0, 20, 51), new TexCoords(20, 0, 20, 51), name, tank);
    }

    private FluidDisplay(int x, int y, TexCoords tankBackground, TexCoords tankOverlay, @Nullable Component name, @Nonnull IFluidTank tank) {
        super(DisplayBounds.of(x, y, tankBackground.w(), tankBackground.h()), 1);
        this.tankBackground = tankBackground;
        this.tankOverlay = tankOverlay;
        this.name = name;
        this.fluidBounds = DisplayBounds.of(x + 2, y + 2, tankBackground.w() - 4, tankBackground.h() - 4);
        this.tank = tank;
    }

    @Override
    protected void tooltip(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, List<Component> tooltip) {
        if (!this.fluidBounds.contains(mouseX, mouseY)) {
            return;
        }
        if (this.name != null) {
            tooltip.add(this.name);
        }
        FluidDisplay.fluidTooltip(this.tank.getFluid(), this.tank.getCapacity(), tooltip);
    }

    public static void fluidTooltip(FluidStack fluidStack, int capacity, List<Component> tooltip) {
        if (fluidStack.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"gui.immersivepetroleum.empty"));
        } else {
            Fluid fluid = fluidStack.getFluid();
            Component ret = fluidStack.getHoverName();
            UnaryOperator styleModifier = fluid.getFluidType().getRarity(fluidStack).getStyleModifier();
            tooltip.add((Component)ret.copy().withStyle((Style)styleModifier.apply(ret.getStyle())));
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid instanceof PotionFluid) {
            PotionFluid potion = (PotionFluid)fluid;
            potion.addInformation(fluidStack, tooltip::add);
        }
        if (capacity > 0) {
            tooltip.add((Component)Component.literal((String)(fluidStack.getAmount() + "/" + capacity + " mB")).withStyle(ChatFormatting.GRAY));
        } else if (capacity == 0) {
            tooltip.add((Component)Component.literal((String)(fluidStack.getAmount() + " mB")).withStyle(ChatFormatting.GRAY));
        }
    }

    @Override
    public void draw(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.blitSprite(guiGraphics, this.tankBackground, this.depth);
        this.drawFluid(guiGraphics, this.fluidBounds, this.tank, this.depth + 1);
        this.blitSprite(guiGraphics, this.tankOverlay, this.depth + 2);
    }

    private void drawFluid(@Nonnull GuiGraphics guiGraphics, DisplayBounds bounds, IFluidTank tank, int depth) {
        FluidStack fluid = tank.getFluid();
        if (fluid.isEmpty()) {
            return;
        }
        IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        TextureAtlasSprite spriteAtlas = MCUtil.getBlockSprite(props.getStillTexture(fluid));
        int spriteW = spriteAtlas.contents().width();
        int spriteH = spriteAtlas.contents().height();
        if (spriteW > 0 && spriteH > 0) {
            int i;
            int tintColor = props.getTintColor(fluid);
            int pixelHeight = (int)((float)bounds.height() * ((float)fluid.getAmount() / (float)tank.getCapacity()));
            int count = pixelHeight / spriteH;
            int left = pixelHeight % spriteH;
            float u0 = spriteAtlas.getU0();
            float v0 = spriteAtlas.getV0();
            float u1 = spriteAtlas.getU1();
            float v1 = spriteAtlas.getV1();
            for (i = 0; i < count; ++i) {
                int h = spriteH * i;
                int x0 = bounds.x0();
                int y0 = bounds.y0() + bounds.height() - spriteH - h;
                int x1 = bounds.x0() + spriteW;
                int y1 = bounds.y0() + bounds.height() - h;
                this.drawQuad(guiGraphics, x0, x1, y0, y1, depth, u0, v0, u1, v1, tintColor);
            }
            if (left > 0) {
                float scale = 1.0f - (float)left / (float)spriteH;
                int h = spriteH * i;
                v0 = spriteAtlas.getV(scale);
                int x0 = bounds.x0();
                int y0 = bounds.y0() + bounds.height() - left - h;
                int x1 = bounds.x0() + spriteW;
                int y1 = bounds.y0() + bounds.height() - h;
                this.drawQuad(guiGraphics, x0, x1, y0, y1, depth, u0, v0, u1, v1, tintColor);
            }
        }
    }

    public static class DebugStorage
    implements IFluidTank {
        private final Fluid fluid;
        private int amount;
        private final int cap;
        private final boolean kittMode;
        private int kitt = 0;
        private boolean up = true;

        public DebugStorage(Fluid fluid, int amount, int capacity, boolean kittMode) {
            this.fluid = fluid;
            this.amount = amount;
            this.cap = capacity;
            this.kittMode = kittMode;
        }

        @Nonnull
        public FluidStack getFluid() {
            int amount = this.getFluidAmount();
            if (amount == 0) {
                return FluidStack.EMPTY;
            }
            return new FluidStack(this.fluid, Math.min(Math.max(amount, 0), this.getCapacity()));
        }

        public int getFluidAmount() {
            if (!this.kittMode) {
                return this.amount;
            }
            if (this.up) {
                ++this.kitt;
                if (this.kitt > this.getCapacity()) {
                    this.kitt = this.getCapacity();
                    this.up = false;
                }
            } else {
                --this.kitt;
                if (this.kitt < 0) {
                    this.kitt = 0;
                    this.up = true;
                }
            }
            this.amount = this.kitt;
            return this.amount;
        }

        public int getCapacity() {
            return this.cap;
        }

        public boolean isFluidValid(@Nonnull FluidStack fluidStack) {
            return false;
        }

        public int fill(@Nonnull FluidStack fluidStack, @Nonnull IFluidHandler.FluidAction fluidAction) {
            return 0;
        }

        @Nonnull
        public FluidStack drain(int i, @Nonnull IFluidHandler.FluidAction fluidAction) {
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(@Nonnull FluidStack fluidStack, @Nonnull IFluidHandler.FluidAction fluidAction) {
            return FluidStack.EMPTY;
        }
    }
}

