/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.gui.displays;

import flaxbeard.immersivepetroleum.client.gui.displays.Display;
import flaxbeard.immersivepetroleum.client.gui.displays.DisplayBounds;
import flaxbeard.immersivepetroleum.client.gui.displays.FluidDisplay;
import flaxbeard.immersivepetroleum.client.gui.displays.TexCoords;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.coker.CokingChamber;
import flaxbeard.immersivepetroleum.common.util.inventory.FluidTankFiltered;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;

public class CokingChamberDisplay
extends Display {
    private final TexCoords raw;
    private final TexCoords processed;
    private final CokingChamber chamber;

    public static CokingChamberDisplay create(int x, int y, @Nonnull CokingChamber chamber) {
        return new CokingChamberDisplay(x, y, new TexCoords(114, 13, 6, 38), new TexCoords(120, 13, 6, 38), chamber);
    }

    public CokingChamberDisplay(int x, int y, TexCoords raw, TexCoords processed, @Nonnull CokingChamber chamber) {
        super(DisplayBounds.of(x, y, raw.w(), raw.h()), 1);
        this.raw = raw;
        this.processed = processed;
        this.chamber = chamber;
    }

    @Override
    protected void tooltip(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, List<Component> tooltip) {
        FluidTankFiltered tank = this.chamber.getTank();
        FluidDisplay.fluidTooltip(tank.getFluid(), tank.getCapacity(), tooltip);
    }

    @Override
    public void draw(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.chamber.getTotalAmount() == 0) {
            return;
        }
        float capacity = this.chamber.getCapacity();
        float outputScale = (float)this.chamber.getOutputAmount() / capacity;
        float capacityScale = (float)this.chamber.getTotalAmount() / capacity;
        this.drawBar(guiGraphics, this.raw, this.bounds, capacityScale, 0);
        this.drawBar(guiGraphics, this.processed, this.bounds, outputScale, 1);
        this.drawFluid(guiGraphics, this.bounds, this.chamber.getTank(), 2);
    }

    private void drawBar(@Nonnull GuiGraphics guiGraphics, TexCoords texCoords, DisplayBounds bounds, float scale, int depth) {
        if (scale <= 0.0f) {
            return;
        }
        TextureAtlasSprite spriteAtlas = MCUtil.getGuiSpriteManager().getSprite(PARTS);
        float spriteW = spriteAtlas.contents().width();
        float spriteH = spriteAtlas.contents().height();
        float u0_ = spriteAtlas.getU0();
        float v0_ = spriteAtlas.getV0();
        float uSize = spriteAtlas.getU1() - u0_;
        float vSize = spriteAtlas.getV1() - v0_;
        scale = (float)texCoords.h() * (1.0f - scale);
        float u0 = u0_ + uSize * ((float)texCoords.x() / spriteW);
        float v0 = v0_ + vSize * ((float)((int)((float)texCoords.y() + scale)) / spriteH);
        float u1 = u0_ + uSize * ((float)(texCoords.x() + texCoords.w()) / spriteW);
        float v1 = v0_ + vSize * ((float)(texCoords.y() + texCoords.h()) / spriteH);
        int x0 = bounds.x0();
        int x1 = bounds.x1();
        int y0 = bounds.y0() + (int)scale;
        int y1 = bounds.y1();
        this.blitSprite(guiGraphics, spriteAtlas, x0, x1, y0, y1, depth, u0, v0, u1, v1);
    }

    private void drawFluid(@Nonnull GuiGraphics guiGraphics, DisplayBounds bounds, IFluidTank tank, int depth) {
        FluidStack fluid = tank.getFluid();
        if (fluid.isEmpty()) {
            return;
        }
        IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        TextureAtlasSprite spriteAtlas = MCUtil.getBlockSprite(props.getStillTexture(fluid));
        int spriteW = Math.min(spriteAtlas.contents().width(), bounds.width());
        int spriteH = spriteAtlas.contents().height();
        if (spriteW > 0 && spriteH > 0) {
            int i;
            int tintColor = props.getTintColor(fluid);
            int pixelHeight = (int)((float)bounds.height() * ((float)fluid.getAmount() / (float)tank.getCapacity()));
            int count = pixelHeight / spriteH;
            int left = pixelHeight % spriteH;
            float u0 = spriteAtlas.getU0();
            float v0 = spriteAtlas.getV0();
            float u1 = spriteAtlas.getU(0.375f);
            float v1 = spriteAtlas.getV1();
            for (i = 0; i < count; ++i) {
                int h = spriteH * i;
                int x0 = bounds.x0();
                int y0 = bounds.y0() + bounds.height() - spriteH - h;
                int x1 = bounds.x0() + spriteW;
                int y1 = bounds.y0() + bounds.height() - h;
                this.drawQuad(guiGraphics, x0, x1, y0, y1, depth, u0, v0, u1, v1, tintColor);
            }
            if (left > 0) {
                float scale = 1.0f - (float)left / (float)spriteH;
                int h = spriteH * i;
                v0 = spriteAtlas.getV(scale);
                int x0 = bounds.x0();
                int y0 = bounds.y0() + bounds.height() - left - h;
                int x1 = bounds.x0() + spriteW;
                int y1 = bounds.y0() + bounds.height() - h;
                this.drawQuad(guiGraphics, x0, x1, y0, y1, depth, u0, v0, u1, v1, tintColor);
            }
        }
    }
}

