/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.gui;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import flaxbeard.immersivepetroleum.client.render.IPRenderTypes;
import flaxbeard.immersivepetroleum.client.render.RenderUtils;
import flaxbeard.immersivepetroleum.client.render.dyn.DynamicTextureWrapper;
import flaxbeard.immersivepetroleum.common.network.MessageSurveyResultDetails;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import flaxbeard.immersivepetroleum.common.util.survey.SurveyScan;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;

public class SeismicSurveyScreen
extends Screen {
    private static final ResourceLocation GUI_TEXTURE = ResourceUtils.ip("textures/gui/seismicsurvey_gui.png");
    private static final ResourceLocation OVERLAY_TEXTURE = ResourceUtils.ip("textures/gui/seismicsurvey_overlay.png");
    private static final int X_SIZE = 154;
    private static final int Y_SIZE = 154;
    private int guiLeft;
    private int guiTop;
    private int surveyLeft;
    private int surveyTop;
    private int surveyRight;
    private int surveyBottom;
    private final int gridScale = 2;
    private float hoverSquareScale;
    boolean requestSent = false;
    private BitSet bitSet;
    @Nonnull
    public final SurveyScan scan;

    public SeismicSurveyScreen(Level level, @Nonnull SurveyScan scan) {
        super((Component)Component.literal((String)"seismicsurveyscreen"));
        this.scan = Objects.requireNonNull(scan);
    }

    protected void init() {
        this.width = Minecraft.getInstance().getWindow().getGuiScaledWidth();
        this.height = Minecraft.getInstance().getWindow().getGuiScaledHeight();
        this.hoverSquareScale = 0.5f - (float)(this.minecraft.getWindow().getGuiScale() / 10.0);
        this.guiLeft = (this.width - 154) / this.gridScale;
        this.guiTop = (this.height - 154) / this.gridScale;
        this.surveyLeft = this.guiLeft + 12;
        this.surveyTop = this.guiTop + 12;
        this.surveyRight = this.surveyLeft + 65 * this.gridScale;
        this.surveyBottom = this.surveyTop + 65 * this.gridScale;
        this.requestSent = true;
        MessageSurveyResultDetails.sendRequestToServer(this.scan);
    }

    public void setBitSet(BitSet bitSet) {
        this.bitSet = bitSet;
    }

    private int getScanData(int x, int y) {
        if (x < 0 || x >= 65 || y < 0 || y >= 65) {
            return -1;
        }
        int index = y * 65 + x;
        return this.scan.data()[index] & 0xFF;
    }

    private boolean hasReservoirAt(int x, int y) {
        if (this.bitSet == null) {
            return false;
        }
        if (x < 0 || x >= 65 || y < 0 || y >= 65) {
            return false;
        }
        int index = Mth.clamp((int)(y * 65 + x), (int)0, (int)4225);
        return this.bitSet.get(index);
    }

    public void renderBackground(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.blit(GUI_TEXTURE, this.guiLeft, this.guiTop, 0, 0, 154, 154);
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        DynamicTextureWrapper wrapper = DynamicTextureWrapper.getOrCreate(65, 65, this.scan);
        if (wrapper == null) {
            return;
        }
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
        int scanX = 64 - (mouseX - this.surveyLeft) / this.gridScale;
        int scanY = 64 - (mouseY - this.surveyTop) / this.gridScale;
        int scanXCentered = scanX - 32;
        int scanYCentered = scanY - 32;
        if (mouseX >= this.guiLeft + 70 && mouseX <= this.guiLeft + 83 && mouseY >= this.guiTop + 4 && mouseY <= this.guiTop + 10) {
            tooltip.add(Component.translatable((String)"gui.immersivepetroleum.dirs.north").withStyle(ChatFormatting.AQUA));
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.surveyLeft, (float)this.surveyTop, 0.0f);
        this.renderScanTexture(guiGraphics, wrapper);
        if (mouseX >= this.surveyLeft && mouseX < this.surveyRight && mouseY >= this.surveyTop && mouseY < this.surveyBottom) {
            int data = this.getScanData(scanX, scanY);
            if (data != -1) {
                this.renderCursorBox(guiGraphics, mouseX, mouseY, 0xFF000000 | (data < 127 ? 0xFFFFFF : 0));
            }
            int worldX = this.scan.getX() - scanXCentered;
            int worldZ = this.scan.getZ() - scanYCentered;
            tooltip.add(Component.translatable((String)"gui.immersivepetroleum.seismicsurvey.worldcoords", (Object[])new Object[]{worldX, worldZ}));
            if (scanXCentered == 0 && scanYCentered == 0) {
                tooltip.add(Component.translatable((String)"gui.immersivepetroleum.seismicsurvey.takenhere").withStyle(ChatFormatting.GRAY));
            }
            if (this.bitSet != null) {
                if (this.hasReservoirAt(scanX, scanY)) {
                    tooltip.add(Component.translatable((String)"gui.immersivepetroleum.seismicsurvey.possibility").withStyle(ChatFormatting.DARK_GRAY));
                }
            } else if (this.requestSent) {
                tooltip.add(Component.translatable((String)"gui.immersivepetroleum.seismicsurvey.awaitingresponse").withStyle(ChatFormatting.GRAY));
            }
        }
        guiGraphics.pose().popPose();
        if (!tooltip.isEmpty()) {
            guiGraphics.renderComponentTooltip(this.font, tooltip, mouseX, mouseY);
        }
    }

    private void renderCursorBox(GuiGraphics guiGraphics, int mouseX, int mouseY, int color) {
        MultiBufferSource.BufferSource buffer = RenderUtils.immediate();
        guiGraphics.pose().pushPose();
        PoseStack poseStack = guiGraphics.pose();
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        poseStack.scale(2.0f, 2.0f, 1.0f);
        PoseStack poseStack2 = guiGraphics.pose();
        float f = mouseX - this.surveyLeft;
        Objects.requireNonNull(this);
        float f2 = f / (2.0f * 1.0f);
        float f3 = mouseY - this.surveyTop;
        Objects.requireNonNull(this);
        poseStack2.translate(f2, f3 / (2.0f * 1.0f), 0.0f);
        VertexConsumer builder = buffer.getBuffer(IPRenderTypes.TRANSLUCENT_POSITION_COLOR);
        Matrix4f mat = guiGraphics.pose().last().pose();
        float s = this.hoverSquareScale;
        builder.addVertex(mat, 0.0f, 0.0f, 0.0f).setColor(color);
        builder.addVertex(mat, 0.0f, s, 0.0f).setColor(color);
        builder.addVertex(mat, 1.0f, s, 0.0f).setColor(color);
        builder.addVertex(mat, 1.0f, 0.0f, 0.0f).setColor(color);
        builder.addVertex(mat, 0.0f, 1.0f - s, 0.0f).setColor(color);
        builder.addVertex(mat, 0.0f, 1.0f, 0.0f).setColor(color);
        builder.addVertex(mat, 1.0f, 1.0f, 0.0f).setColor(color);
        builder.addVertex(mat, 1.0f, 1.0f - s, 0.0f).setColor(color);
        builder.addVertex(mat, 0.0f, 0.0f, 0.0f).setColor(color);
        builder.addVertex(mat, 0.0f, 1.0f, 0.0f).setColor(color);
        builder.addVertex(mat, s, 1.0f, 0.0f).setColor(color);
        builder.addVertex(mat, s, 0.0f, 0.0f).setColor(color);
        builder.addVertex(mat, 1.0f - s, 0.0f, 0.0f).setColor(color);
        builder.addVertex(mat, 1.0f - s, 1.0f, 0.0f).setColor(color);
        builder.addVertex(mat, 1.0f, 1.0f, 0.0f).setColor(color);
        builder.addVertex(mat, 1.0f, 0.0f, 0.0f).setColor(color);
        guiGraphics.pose().popPose();
        buffer.endBatch();
    }

    private void renderScanTexture(GuiGraphics guiGraphics, DynamicTextureWrapper wrapper) {
        MultiBufferSource.BufferSource buffer = RenderUtils.immediate();
        guiGraphics.pose().pushPose();
        PoseStack poseStack = guiGraphics.pose();
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        poseStack.scale(2.0f, 2.0f, 1.0f);
        VertexConsumer builder = buffer.getBuffer(wrapper.renderType);
        Matrix4f mat = guiGraphics.pose().last().pose();
        int a = wrapper.width;
        int b = wrapper.height;
        builder.addVertex(mat, 0.0f, 0.0f, 0.0f).setColor(-1).setUv(1.0f, 1.0f).setLight(0xF000F0);
        builder.addVertex(mat, 0.0f, (float)b, 0.0f).setColor(-1).setUv(1.0f, 0.0f).setLight(0xF000F0);
        builder.addVertex(mat, (float)a, (float)b, 0.0f).setColor(-1).setUv(0.0f, 0.0f).setLight(0xF000F0);
        builder.addVertex(mat, (float)a, 0.0f, 0.0f).setColor(-1).setUv(0.0f, 1.0f).setLight(0xF000F0);
        builder = buffer.getBuffer(RenderType.text((ResourceLocation)OVERLAY_TEXTURE));
        builder.addVertex(mat, 0.0f, 0.0f, 0.0f).setColor(-1).setUv(0.0f, 0.0f).setLight(0xF000F0);
        builder.addVertex(mat, 0.0f, (float)b, 0.0f).setColor(-1).setUv(0.0f, 1.0f).setLight(0xF000F0);
        builder.addVertex(mat, (float)a, (float)b, 0.0f).setColor(-1).setUv(1.0f, 1.0f).setLight(0xF000F0);
        builder.addVertex(mat, (float)a, 0.0f, 0.0f).setColor(-1).setUv(1.0f, 0.0f).setLight(0xF000F0);
        guiGraphics.pose().popPose();
        buffer.endBatch();
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        InputConstants.Key key = InputConstants.getKey((int)pKeyCode, (int)pScanCode);
        if (this.minecraft != null && this.minecraft.options.keyInventory.isActiveAndMatches(key)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

