/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.gui;

import blusunrize.immersiveengineering.api.multiblocks.ClientMultiblocks;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.api.utils.TemplateWorldCreator;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import flaxbeard.immersivepetroleum.client.gui.elements.GuiReactiveList;
import flaxbeard.immersivepetroleum.client.render.RenderUtils;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.items.ProjectorItem;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import flaxbeard.immersivepetroleum.common.util.projector.Settings;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.neoforged.neoforge.client.model.data.ModelData;

public class ProjectorScreen
extends Screen {
    static final ResourceLocation GUI_TEXTURE = ResourceUtils.ip("textures/gui/projector.png");
    static final Component GUI_CONFIRM = ProjectorScreen.translation("gui.immersivepetroleum.projector.button.confirm");
    static final Component GUI_CANCEL = ProjectorScreen.translation("gui.immersivepetroleum.projector.button.cancel");
    static final Component GUI_MIRROR = ProjectorScreen.translation("gui.immersivepetroleum.projector.button.mirror");
    static final Component GUI_ROTATE_CW = ProjectorScreen.translation("gui.immersivepetroleum.projector.button.rcw");
    static final Component GUI_ROTATE_CCW = ProjectorScreen.translation("gui.immersivepetroleum.projector.button.rccw");
    static final Component GUI_UP = ProjectorScreen.translation("gui.immersivepetroleum.projector.button.up");
    static final Component GUI_DOWN = ProjectorScreen.translation("gui.immersivepetroleum.projector.button.down");
    static final Component GUI_SEARCH = ProjectorScreen.translation("gui.immersivepetroleum.projector.search");
    private final int xSize = 256;
    private final int ySize = 166;
    private int guiLeft;
    private int guiTop;
    private final Supplier<List<MultiblockHandler.IMultiblock>> multiblocks;
    private GuiReactiveList<MultiblockHandler.IMultiblock> list;
    private Level templateWorld;
    private MultiblockHandler.IMultiblock selectedMultiblock;
    private SearchField searchField;
    Settings settings;
    InteractionHand hand;
    float rotation = 0.0f;
    float move = 0.0f;

    public ProjectorScreen(InteractionHand hand, ItemStack projector) {
        super((Component)Component.literal((String)"projector"));
        this.settings = ProjectorItem.getSettings(projector);
        this.hand = hand;
        this.multiblocks = () -> MultiblockHandler.getMultiblocks().stream().filter(mb -> {
            if (mb.getUniqueName().toString().equals("immersiveengineering:feedthrough")) {
                return false;
            }
            String name = mb.getDisplayName().getString().toLowerCase();
            return name.contains(this.searchField.getValue().toLowerCase());
        }).sorted((a, b) -> {
            String nameA = a.getDisplayName().getString();
            String nameB = b.getDisplayName().getString();
            return nameA.compareToIgnoreCase(nameB);
        }).toList();
        if (this.settings.getMultiblock() != null) {
            this.move = 20.0f;
        }
    }

    protected void init() {
        this.width = Minecraft.getInstance().getWindow().getGuiScaledWidth();
        this.height = Minecraft.getInstance().getWindow().getGuiScaledHeight();
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
        this.searchField = (SearchField)this.addRenderableWidget((GuiEventListener)new SearchField(this.font, this.guiLeft + 25, this.guiTop + 13));
        this.addRenderableWidget((GuiEventListener)new ConfirmButton(this, this.guiLeft + 115, this.guiTop + 10, but -> {
            this.settings.setMode(Settings.Mode.PROJECTION);
            ItemStack held = MCUtil.getPlayer().getItemInHand(this.hand);
            this.settings.applyTo(held);
            this.settings.sendPacketToServer(this.hand);
            MCUtil.getScreen().onClose();
            MCUtil.getPlayer().displayClientMessage(this.settings.getMode().getTranslated(), true);
        }));
        this.addRenderableWidget((GuiEventListener)new CancelButton(this, this.guiLeft + 115, this.guiTop + 34, but -> MCUtil.getScreen().onClose()));
        this.addRenderableWidget((GuiEventListener)new MirrorButton(this, this.guiLeft + 115, this.guiTop + 58, this.settings, but -> this.settings.flip()));
        this.addRenderableWidget((GuiEventListener)new RotateLeftButton(this, this.guiLeft + 115, this.guiTop + 106, but -> this.settings.rotateCCW()));
        this.addRenderableWidget((GuiEventListener)new RotateRightButton(this, this.guiLeft + 115, this.guiTop + 130, but -> this.settings.rotateCW()));
        GuiReactiveList<MultiblockHandler.IMultiblock> guiList = new GuiReactiveList<MultiblockHandler.IMultiblock>(this.guiLeft + 15, this.guiTop + 29, 89, 127, this::listaction, this.multiblocks, iMultiblock -> iMultiblock.getDisplayName().getString());
        guiList.setPadding(1, 1, 1, 1);
        guiList.setTextStyling(0, 0x7F7FFF, false);
        this.list = (GuiReactiveList)this.addRenderableWidget((GuiEventListener)guiList);
    }

    private void listaction(GuiReactiveList<MultiblockHandler.IMultiblock> button) {
        List<MultiblockHandler.IMultiblock> mbList = this.multiblocks.get();
        if (this.list.selectedOption >= 0 && this.list.selectedOption < mbList.size()) {
            MultiblockHandler.IMultiblock iMultiblock = mbList.get(this.list.selectedOption);
            this.settings.setMultiblock(iMultiblock);
        }
    }

    public void renderBackground(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.settings.getMultiblock() != null) {
            MultiblockHandler.IMultiblock mb = this.settings.getMultiblock();
            int x = this.guiLeft + 28;
            int y = this.guiTop - (int)(15.0f * (this.move / 20.0f));
            if (this.move < 20.0f) {
                this.move += 0.5f * partialTick;
                if (this.move > 20.0f) {
                    this.move = 20.0f;
                }
            }
            guiGraphics.blit(GUI_TEXTURE, x, y, 0, 166, 200, 13);
            Component text = mb.getDisplayName();
            FormattedCharSequence re = text.getVisualOrderText();
            guiGraphics.drawString(this.font, re, (x += 100) - this.font.width(re) / 2, y += 3, 0x3F3F3F, false);
        }
        RenderSystem.enableBlend();
        guiGraphics.blit(GUI_TEXTURE, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        RenderSystem.disableBlend();
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.searchField.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderDirectionDisplay(guiGraphics, mouseX, mouseY);
        PoseStack transform = guiGraphics.pose();
        if (this.settings.getMultiblock() != null) {
            MultiblockHandler.IMultiblock mb = this.settings.getMultiblock();
            MultiBufferSource.BufferSource buffer = RenderUtils.immediate();
            try {
                long millis = System.currentTimeMillis();
                Vec3i size = mb.getSize(null);
                transform.pushPose();
                transform.translate((float)(this.guiLeft + 190), (float)(this.guiTop + 80), 64.0f);
                transform.scale(mb.getManualScale(), -mb.getManualScale(), 1.0f);
                transform.mulPose(Axis.XP.rotationDegrees(25.0f));
                transform.mulPose(Axis.YP.rotationDegrees(45.0f - ((float)(millis / 20L % 360L) + 1.0f * ((float)(millis % 20L) / 20.0f))));
                transform.translate((float)size.getX() / -2.0f, (float)size.getY() / -2.0f, (float)size.getZ() / -2.0f);
                ClientMultiblocks.MultiblockManualData mbClientData = ClientMultiblocks.get((MultiblockHandler.IMultiblock)mb);
                boolean tempDisable = false;
                if (!tempDisable && mbClientData.canRenderFormedStructure()) {
                    transform.pushPose();
                    mbClientData.renderFormedStructure(transform, (MultiBufferSource)buffer);
                    transform.popPose();
                } else {
                    ClientLevel clientLevel = this.getMinecraft().level;
                    if (this.templateWorld == null || !this.selectedMultiblock.getUniqueName().equals((Object)mb.getUniqueName())) {
                        this.templateWorld = ((TemplateWorldCreator)TemplateWorldCreator.CREATOR.get()).makeWorld(mb.getStructure((Level)clientLevel), pos -> true, clientLevel.registryAccess());
                        this.selectedMultiblock = mb;
                    }
                    BlockRenderDispatcher blockRender = Minecraft.getInstance().getBlockRenderer();
                    List infos = mb.getStructure((Level)clientLevel);
                    for (StructureTemplate.StructureBlockInfo info : infos) {
                        if (info.state().is(Blocks.AIR)) continue;
                        transform.pushPose();
                        transform.translate((float)info.pos().getX(), (float)info.pos().getY(), (float)info.pos().getZ());
                        ModelData modelData = ModelData.EMPTY;
                        BlockEntity te = this.templateWorld.getBlockEntity(info.pos());
                        if (te != null) {
                            modelData = te.getModelData();
                        }
                        blockRender.renderSingleBlock(info.state(), transform, (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.NO_OVERLAY, modelData, null);
                        transform.popPose();
                    }
                }
                transform.popPose();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            buffer.endBatch();
        }
    }

    private void renderDirectionDisplay(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int x = this.guiLeft + 115;
        int y = this.guiTop + 82;
        Direction dir = Direction.from2DDataValue((int)this.settings.getRotation().ordinal());
        MutableComponent dirText = Component.literal((String)dir.toString().toUpperCase().substring(0, 1));
        guiGraphics.drawCenteredString(this.font, (Component)dirText, x + 5, y + 1, -1);
        if (mouseX > x && mouseX < x + 10 && mouseY > y && mouseY < y + 10) {
            MutableComponent rotText = Component.translatable((String)("desc.immersivepetroleum.info.projector.rotated." + String.valueOf(dir)));
            guiGraphics.renderTooltip(this.font, (Component)rotText, mouseX, mouseY);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return super.keyPressed(keyCode, scanCode, modifiers) || this.searchField.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        return super.charTyped(codePoint, modifiers) || this.searchField.charTyped(codePoint, modifiers);
    }

    public boolean isPauseScreen() {
        return false;
    }

    static Component translation(String key) {
        return Component.translatable((String)key);
    }

    static class SearchField
    extends EditBox {
        public SearchField(Font font, int x, int y) {
            super(font, x, y, 60, 14, GUI_SEARCH);
            this.setMaxLength(50);
            this.setBordered(false);
            this.setVisible(true);
            this.setTextColor(0xFFFFFF);
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            if (super.keyPressed(keyCode, scanCode, modifiers)) {
                return true;
            }
            return this.isFocused() && this.isVisible() && keyCode != 256 || super.keyPressed(keyCode, scanCode, modifiers);
        }

        public boolean charTyped(char codePoint, int modifiers) {
            if (!this.isFocused()) {
                this.setFocused(true);
            }
            return super.charTyped(codePoint, modifiers);
        }
    }

    class ConfirmButton
    extends ControlButton {
        public ConfirmButton(ProjectorScreen this$0, int x, int y, Consumer<PButton> action) {
            super(x, y, 10, 10, 0, 179, action, GUI_CONFIRM);
        }
    }

    class CancelButton
    extends ControlButton {
        public CancelButton(ProjectorScreen this$0, int x, int y, Consumer<PButton> action) {
            super(x, y, 10, 10, 10, 179, action, GUI_CANCEL);
        }
    }

    class MirrorButton
    extends ControlButton {
        Settings settings;

        public MirrorButton(ProjectorScreen this$0, int x, int y, Settings settings, Consumer<PButton> action) {
            super(x, y, 10, 10, 20, 179, action, GUI_MIRROR);
            this.settings = settings;
        }

        @Override
        public void renderWidget(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            if (this.isHovered) {
                guiGraphics.fill(this.getX(), this.getY() + 1, this.getX() + this.iconSize, this.getY() + this.iconSize - 1, -1350598657);
            }
            if (this.settings.isMirrored()) {
                guiGraphics.blit(GUI_TEXTURE, this.getX(), this.getY(), this.xOverlay, this.yOverlay + this.iconSize, this.iconSize, this.iconSize);
            } else {
                guiGraphics.blit(GUI_TEXTURE, this.getX(), this.getY(), this.xOverlay, this.yOverlay, this.iconSize, this.iconSize);
            }
        }
    }

    class RotateLeftButton
    extends ControlButton {
        public RotateLeftButton(ProjectorScreen this$0, int x, int y, Consumer<PButton> action) {
            super(x, y, 10, 10, 30, 179, action, GUI_ROTATE_CCW);
        }
    }

    class RotateRightButton
    extends ControlButton {
        public RotateRightButton(ProjectorScreen this$0, int x, int y, Consumer<PButton> action) {
            super(x, y, 10, 10, 40, 179, action, GUI_ROTATE_CW);
        }
    }

    static class PButton
    extends AbstractButton {
        protected boolean selected;
        protected final int xOverlay;
        protected final int yOverlay;
        protected int iconSize = 10;
        protected int bgStartX = 0;
        protected int bgStartY = 166;
        protected Consumer<PButton> action;

        public PButton(int x, int y, int width, int height, int overlayX, int overlayY, Consumer<PButton> action) {
            super(x, y, width, height, (Component)Component.empty());
            this.action = action;
            this.xOverlay = overlayX;
            this.yOverlay = overlayY;
        }

        public void renderWidget(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            if (this.isHovered) {
                guiGraphics.fill(this.getX(), this.getY() + 1, this.getX() + this.iconSize, this.getY() + this.iconSize - 1, -1350598657);
            }
            guiGraphics.blit(GUI_TEXTURE, this.getX(), this.getY(), this.xOverlay, this.yOverlay, this.iconSize, this.iconSize);
        }

        public void onPress() {
            this.action.accept(this);
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean isSelected) {
            this.selected = isSelected;
        }

        protected void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
        }
    }

    static class ControlButton
    extends PButton {
        Component hoverText;

        public ControlButton(int x, int y, int width, int height, int overlayX, int overlayY, Consumer<PButton> action, Component hoverText) {
            super(x, y, width, height, overlayX, overlayY, action);
            this.hoverText = hoverText;
        }
    }
}

