/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client;

import com.mojang.blaze3d.shaders.AbstractUniform;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import java.io.IOException;
import net.minecraft.client.renderer.ShaderInstance;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;

@EventBusSubscriber(value={Dist.CLIENT}, modid="immersivepetroleum", bus=EventBusSubscriber.Bus.MOD)
public class IPShaders {
    private static ShaderInstance shader_line;
    private static ShaderInstance shader_projection;
    private static ShaderInstance shader_translucent_full;
    private static ShaderInstance shader_translucent_postion_color;
    private static AbstractUniform projection_alpha;
    private static AbstractUniform projection_time;

    public static void projNoise(float alpha, float time) {
        projection_alpha.set(alpha);
        projection_time.set(time);
    }

    @SubscribeEvent
    public static void registerShaders(RegisterShadersEvent event) throws IOException {
        event.registerShader(new ShaderInstance(event.getResourceProvider(), ResourceUtils.ip("rendertype_line"), DefaultVertexFormat.POSITION_COLOR), s -> {
            ImmersivePetroleum.log.debug("rendertype_line shader loaded.");
            shader_line = s;
        });
        event.registerShader(new ShaderInstance(event.getResourceProvider(), ResourceUtils.ip("rendertype_projection"), DefaultVertexFormat.BLOCK), s -> {
            ImmersivePetroleum.log.debug("rendertype_projection shader loaded.");
            shader_projection = s;
            projection_alpha = shader_projection.safeGetUniform("Alpha");
            projection_time = shader_projection.safeGetUniform("Time");
        });
        event.registerShader(new ShaderInstance(event.getResourceProvider(), ResourceUtils.ip("rendertype_translucent_postion_color"), DefaultVertexFormat.POSITION_COLOR), s -> {
            ImmersivePetroleum.log.debug("rendertype_translucent_postion_color shader loaded.");
            shader_translucent_postion_color = s;
        });
        event.registerShader(new ShaderInstance(event.getResourceProvider(), ResourceUtils.ip("rendertype_translucent"), DefaultVertexFormat.BLOCK), s -> {
            ImmersivePetroleum.log.debug("rendertype_translucent shader loaded.");
            shader_translucent_full = s;
        });
    }

    public static ShaderInstance getTranslucentLineShader() {
        return shader_line;
    }

    public static ShaderInstance getProjectionStaticShader() {
        return shader_projection;
    }

    public static ShaderInstance getTranslucentShader() {
        return shader_translucent_full;
    }

    public static ShaderInstance getTranslucentPostionColorShader() {
        return shader_translucent_postion_color;
    }
}

