/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client;

import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelper;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import blusunrize.immersiveengineering.common.blocks.metal.MetalScaffoldingType;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.mixin.accessors.client.GuiSubtitleOverlayAccess;
import blusunrize.lib.manual.ManualElementItem;
import blusunrize.lib.manual.ManualElementTable;
import blusunrize.lib.manual.ManualEntry;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.SpecialManualElement;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.api.crafting.FlarestackHandler;
import flaxbeard.immersivepetroleum.api.energy.FuelHandler;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirType;
import flaxbeard.immersivepetroleum.client.ClientEventHandler;
import flaxbeard.immersivepetroleum.client.gui.machines.IPContainerScreen_CokerUnit;
import flaxbeard.immersivepetroleum.client.gui.machines.IPContainerScreen_Derrick;
import flaxbeard.immersivepetroleum.client.gui.machines.IPContainerScreen_DistillationTower;
import flaxbeard.immersivepetroleum.client.gui.machines.IPContainerScreen_Hydrotreater;
import flaxbeard.immersivepetroleum.client.particle.FluidParticleData;
import flaxbeard.immersivepetroleum.client.render.RenderUtils;
import flaxbeard.immersivepetroleum.client.render.SeismicResultRenderer;
import flaxbeard.immersivepetroleum.client.render.debugging.DebugRenderHandler;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.CommonProxy;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.IPMenuTypes;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.PumpjackLogic;
import flaxbeard.immersivepetroleum.common.cfg.IPServerConfig;
import flaxbeard.immersivepetroleum.common.crafting.RecipeReloadListener;
import flaxbeard.immersivepetroleum.common.sound.IPEntitySound;
import flaxbeard.immersivepetroleum.common.sound.IPTickableSound;
import flaxbeard.immersivepetroleum.common.sound.IPWorldSound;
import flaxbeard.immersivepetroleum.common.sound.IPlaySound;
import flaxbeard.immersivepetroleum.common.util.RegistryUtils;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import flaxbeard.immersivepetroleum.common.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.SubtitleOverlay;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.fluids.FluidStack;

public class ClientProxy
extends CommonProxy {
    private final Map<BlockPos, IPWorldSound> worldSoundMap = new HashMap<BlockPos, IPWorldSound>();
    private final Map<UUID, IPEntitySound> entitySoundMap = new HashMap<UUID, IPEntitySound>();
    private static final int SUBTITLE_RANGE = 16;

    @Override
    public void setup(FMLCommonSetupEvent event) {
        NeoForge.EVENT_BUS.register((Object)new ClientEventHandler());
        NeoForge.EVENT_BUS.register((Object)new RecipeReloadListener(null));
        NeoForge.EVENT_BUS.register((Object)new DebugRenderHandler());
        NeoForge.EVENT_BUS.register((Object)new SeismicResultRenderer());
    }

    @Override
    public void registerContainersAndScreens(RegisterMenuScreensEvent ev) {
        ev.register(IPMenuTypes.DISTILLATION_TOWER.getType(), IPContainerScreen_DistillationTower::new);
        ev.register(IPMenuTypes.COKER.getType(), IPContainerScreen_CokerUnit::new);
        ev.register(IPMenuTypes.DERRICK.getType(), IPContainerScreen_Derrick::new);
        ev.register(IPMenuTypes.HYDROTREATER.getType(), IPContainerScreen_Hydrotreater::new);
    }

    @Override
    public void completed(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> ManualHelper.addConfigGetter(str -> switch (str) {
            case "distillationtower_operationcost" -> (int)(1024.0 * (Double)IPServerConfig.REFINING.distillationTower_energyModifier.get());
            case "coker_operationcost" -> (int)(1024.0 * (Double)IPServerConfig.REFINING.cokerUnit_energyModifier.get());
            case "hydrotreater_operationcost_lower" -> (int)(80.0 * (Double)IPServerConfig.REFINING.hydrotreater_energyModifier.get());
            case "hydrotreater_operationcost_upper" -> (int)(512.0 * (Double)IPServerConfig.REFINING.hydrotreater_energyModifier.get());
            case "pumpjack_consumption" -> (Integer)IPServerConfig.EXTRACTION.pumpjack_consumption.get();
            case "pumpjack_speed" -> (Integer)IPServerConfig.EXTRACTION.pumpjack_speed.get();
            case "pumpjack_days" -> {
                int oil_min = 1000000;
                int oil_max = 5000000;
                for (RecipeHolder<ReservoirType> holder : ReservoirType.map.values()) {
                    ReservoirType reservoir = (ReservoirType)holder.value();
                    if (!reservoir.name.equals("oil")) continue;
                    oil_min = reservoir.minSize;
                    oil_max = reservoir.maxSize;
                    break;
                }
                float averageSize = (float)(oil_min + oil_max) / 2.0f;
                float pumpspeed = ((Integer)IPServerConfig.EXTRACTION.pumpjack_speed.get()).intValue();
                yield Mth.floor((float)(averageSize / pumpspeed / 24000.0f));
            }
            case "autolubricant_speedup" -> 1.25;
            case "portablegenerator_flux" -> FuelHandler.getFluxGeneratedPerTick((Fluid)IPContent.Fluids.GASOLINE.source().get());
            default -> {
                CommentedConfig cfg = IPServerConfig.getRawConfig();
                if (cfg.contains(str)) {
                    yield cfg.get(str);
                }
                yield null;
            }
        }));
        this.setupManualPages();
    }

    @Override
    public void renderTile(BlockEntity te, VertexConsumer iVertexBuilder, PoseStack transform, MultiBufferSource buffer) {
        IMultiblockBE multiblockBE;
        BlockEntityRenderer tesr = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(te);
        if (tesr == null) {
            return;
        }
        if (te instanceof IMultiblockBE && (multiblockBE = (IMultiblockBE)te).getHelper().getContext() != null && multiblockBE.getHelper().getContext().getState() instanceof PumpjackLogic.State) {
            IMultiblockBEHelper helper = multiblockBE.getHelper().asType(IPContent.Multiblock.PUMPJACK);
            transform.pushPose();
            transform.mulPose(Axis.YN.rotationDegrees(90.0f));
            transform.translate(1.0f, 1.0f, -2.0f);
            float pt = 0.0f;
            if (MCUtil.getPlayer() != null && helper != null && helper.getState() != null) {
                ((PumpjackLogic.State)helper.getState()).activeTicks = MCUtil.getPlayer().tickCount;
                pt = Minecraft.getInstance().getTimer().getGameTimeDeltaTicks();
            }
            tesr.render(te, pt, transform, buffer, 0xF000F0, OverlayTexture.NO_OVERLAY);
            transform.popPose();
        } else {
            transform.pushPose();
            transform.mulPose(Axis.YN.rotationDegrees(90.0f));
            transform.translate(0.0f, 1.0f, -4.0f);
            tesr.render(te, 0.0f, transform, buffer, 0xF000F0, OverlayTexture.NO_OVERLAY);
            transform.popPose();
        }
    }

    @Override
    public void drawUpperHalfSlab(PoseStack transform, ItemStack stack) {
        BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
        BlockState state = ((IEBlocks.BlockEntry)IEBlocks.MetalDecoration.STEEL_SCAFFOLDING.get(MetalScaffoldingType.STANDARD)).defaultBlockState();
        BakedModel model = blockRenderer.getBlockModelShaper().getBlockModel(state);
        MultiBufferSource.BufferSource buffers = RenderUtils.immediate();
        transform.pushPose();
        transform.translate(0.0f, 0.5f, 1.0f);
        blockRenderer.getModelRenderer().renderModel(transform.last(), buffers.getBuffer(RenderType.solid()), state, model, 1.0f, 1.0f, 1.0f, -1, -1, ModelData.EMPTY, RenderType.cutout());
        transform.popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnSpillParticles(Level world, BlockPos pos, Fluid fluid, int particles, float yOffset, float flow) {
        if (fluid == null || fluid == Fluids.EMPTY) {
            return;
        }
        for (int i = 0; i < particles; ++i) {
            float xa = (world.random.nextFloat() - 0.5f) / 2.0f;
            float ya = 0.25f + (0.5f + world.random.nextFloat() * 0.25f) * flow / 800.0f;
            float za = (world.random.nextFloat() - 0.5f) / 2.0f;
            float rx = (world.random.nextFloat() - 0.5f) * 0.5f;
            float rz = (world.random.nextFloat() - 0.5f) * 0.5f;
            double x = (double)pos.getX() + 0.5 + (double)rx;
            double y = (float)pos.getY() + yOffset;
            double z = (double)pos.getZ() + 0.5 + (double)rz;
            world.addParticle((ParticleOptions)new FluidParticleData(fluid), x, y, z, (double)xa, (double)ya, (double)za);
        }
    }

    @Override
    public Level getClientWorld() {
        return MCUtil.getLevel();
    }

    @Override
    public Player getClientPlayer() {
        return MCUtil.getPlayer();
    }

    @Override
    public void handleTileSound(Holder<SoundEvent> soundEvent, BlockEntity te, boolean active, float volume, float pitch) {
        BlockPos pos = te.getBlockPos();
        IPWorldSound worldSound = this.worldSoundMap.get(pos);
        if (worldSound == null && active) {
            if (te instanceof IPlaySound) {
                IPlaySound soundPlayer = (IPlaySound)te;
                if (MCUtil.getPlayer().distanceToSqr(Vec3.atCenterOf((Vec3i)pos)) > (double)soundPlayer.soundRadiusSqr()) {
                    return;
                }
            }
            this.playSound(this.worldSoundMap, new IPWorldSound(pos, (SoundEvent)soundEvent.value(), volume, pitch), pos);
        } else if (worldSound != null) {
            WeighedSoundEvents weighedSoundEvents;
            if (worldSound.isStopped() || !active || !((SoundEvent)soundEvent.value()).getLocation().equals((Object)worldSound.getLocation())) {
                this.stopSound(this.worldSoundMap, worldSound, pos);
            } else if (!worldSound.isStopped() && MCUtil.getPlayer().tickCount % 20 == 0 && (weighedSoundEvents = worldSound.resolve(MCUtil.getSoundManager())) != null) {
                this.getSubtitleOverlay().onPlaySound((SoundInstance)worldSound, weighedSoundEvents, 16.0f);
            }
        }
    }

    @Override
    public void handleEntitySound(Holder<SoundEvent> soundEvent, Entity entity, boolean active, float volume, float pitch) {
        IPEntitySound entitySound = this.entitySoundMap.get(entity.getUUID());
        if (entitySound == null && active) {
            if (entity instanceof IPlaySound) {
                IPlaySound soundPlayer = (IPlaySound)entity;
                if (MCUtil.getPlayer().distanceToSqr(entity) > (double)soundPlayer.soundRadiusSqr()) {
                    return;
                }
            }
            this.playSound(this.entitySoundMap, new IPEntitySound(entity, (SoundEvent)soundEvent.value(), volume, pitch), entity.getUUID());
        } else if (entitySound != null) {
            WeighedSoundEvents weighedSoundEvents;
            if (entitySound.isStopped() || !active || !((SoundEvent)soundEvent.value()).getLocation().equals((Object)entitySound.getLocation())) {
                this.stopSound(this.entitySoundMap, entitySound, entity.getUUID());
            } else if (!entitySound.isStopped() && MCUtil.getPlayer().tickCount % 20 == 0 && (weighedSoundEvents = entitySound.resolve(MCUtil.getSoundManager())) != null) {
                this.getSubtitleOverlay().onPlaySound((SoundInstance)entitySound, weighedSoundEvents, 16.0f);
            }
        }
    }

    private <Key, Sound extends IPTickableSound, M extends Map<Key, Sound>> void playSound(M map, Sound sound, Key key) {
        map.put(key, sound);
        MCUtil.getSoundManager().play(sound);
    }

    private <Key, Sound extends IPTickableSound, M extends Map<Key, Sound>> void stopSound(M map, Sound sound, Key key) {
        if (sound == null) {
            return;
        }
        sound.stop();
        MCUtil.getSoundManager().stop(sound);
        map.remove(key);
    }

    private SubtitleOverlay getSubtitleOverlay() {
        return ((GuiSubtitleOverlayAccess)Minecraft.getInstance().gui).getSubtitleOverlay();
    }

    public void setupManualPages() {
        ClientProxy.handleReservoirManual(ResourceUtils.ip("reservoir"), 0);
        ClientProxy.flarestack(ResourceUtils.ip("flarestack"), 12);
    }

    private static void flarestack(ResourceLocation location, int priority) {
        ManualInstance man = ManualHelper.getManual();
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(man);
        builder.readFromFile(location);
        builder.appendText(() -> {
            ArrayList list = new ArrayList();
            BuiltInRegistries.FLUID.stream().forEach(fluid -> {
                for (TagKey<Fluid> tag : FlarestackHandler.getSet()) {
                    if (!fluid.is(tag)) continue;
                    Component[] entry = new Component[]{Component.empty(), new FluidStack(fluid, 1).getHoverName()};
                    list.add(entry);
                }
            });
            StringBuilder additionalText = new StringBuilder();
            ArrayList<ManualEntry.SpecialElementData> newElements = new ArrayList<ManualEntry.SpecialElementData>();
            int nextLine = 0;
            int page = 0;
            while (nextLine < list.size()) {
                int linesOnPage = page == 0 ? 12 : 14;
                int endIndex = Math.min(nextLine + linesOnPage, list.size());
                List onPage = list.subList(nextLine, endIndex);
                nextLine = endIndex;
                String key = "flarestack_table" + page;
                additionalText.append("<&").append(key).append(">");
                newElements.add(new ManualEntry.SpecialElementData(key, 0, (SpecialManualElement)new ManualElementTable(man, (Component[][])onPage.toArray(x$0 -> new Component[x$0][]), false)));
                ++page;
            }
            return Pair.of((Object)additionalText.toString(), newElements);
        });
        man.addEntry(man.getRoot().getOrCreateSubnode((Comparable)ResourceUtils.ip("petroleum")), builder.create(), priority);
    }

    private static void handleReservoirManual(ResourceLocation location, int priority) {
        ManualInstance man = ManualHelper.getManual();
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(man);
        builder.setContent(ClientProxy::createContent);
        builder.setLocation(location);
        man.addEntry(man.getRoot().addNewSubnode((Comparable)ResourceUtils.ip("petroleum"), 100), builder.create(), priority);
    }

    protected static ManualEntry.EntryData createContent() {
        String tString;
        ArrayList<ManualEntry.SpecialElementData> itemList = new ArrayList<ManualEntry.SpecialElementData>();
        StringBuilder contentBuilder = new StringBuilder();
        for (int i = 0; i < 5 && !I18n.get((String)(tString = "ie.manual.entry.reservoirs.oil" + i), (Object[])new Object[0]).equals(tString); ++i) {
            contentBuilder.append(I18n.get((String)tString, (Object[])new Object[0]));
        }
        ClientProxy.createReservoirPages(contentBuilder, itemList);
        String translatedTitle = I18n.get((String)"ie.manual.entry.reservoirs.title", (Object[])new Object[0]);
        String tanslatedSubtext = I18n.get((String)"ie.manual.entry.reservoirs.subtitle", (Object[])new Object[0]);
        String formattedContent = contentBuilder.toString().replaceAll("\r\n|\r|\n", "\n");
        return new ManualEntry.EntryData(translatedTitle, tanslatedSubtext, formattedContent, itemList);
    }

    private static void createReservoirPages(StringBuilder contentBuilder, ArrayList<ManualEntry.SpecialElementData> itemList) {
        ReservoirType[] reservoirs = (ReservoirType[])ReservoirType.map.values().stream().map(RecipeHolder::value).toArray(ReservoirType[]::new);
        for (int i = 0; i < reservoirs.length; ++i) {
            StringBuilder strBuilder;
            char c;
            ReservoirType reservoir = reservoirs[i];
            ImmersivePetroleum.log.debug("Creating entry for " + String.valueOf((Object)reservoir));
            String name = "desc.immersivepetroleum.info.reservoir." + reservoir.name;
            String localizedName = I18n.get((String)name, (Object[])new Object[0]);
            if (localizedName.equalsIgnoreCase(name)) {
                localizedName = reservoir.name;
            }
            boolean isVowel = (c = localizedName.toLowerCase().charAt(0)) == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u';
            String aOrAn = I18n.get((String)(isVowel ? "ie.manual.entry.reservoirs.vowel" : "ie.manual.entry.reservoirs.consonant"), (Object[])new Object[0]);
            String dimBWList = "";
            String bioBWList = "";
            if (reservoir.getDimensions().hasEntries()) {
                strBuilder = new StringBuilder();
                reservoir.getDimensions().forEach(rl -> strBuilder.append(!strBuilder.isEmpty() ? ", " : "").append("<dim;").append(rl).append(">"));
                dimBWList = reservoir.getDimensions().isBlacklist() ? I18n.get((String)"ie.manual.entry.reservoirs.dim.invalid", (Object[])new Object[]{localizedName, strBuilder.toString(), aOrAn}) : I18n.get((String)"ie.manual.entry.reservoirs.dim.valid", (Object[])new Object[]{localizedName, strBuilder.toString(), aOrAn});
            } else {
                dimBWList = I18n.get((String)"ie.manual.entry.reservoirs.dim.any", (Object[])new Object[]{localizedName, aOrAn});
            }
            if (reservoir.getBiomes().hasEntries()) {
                strBuilder = new StringBuilder();
                reservoir.getBiomes().forEach(rl -> {
                    Biome biome = RegistryUtils.getBiomeFromRegistryName(rl);
                    strBuilder.append(!strBuilder.isEmpty() ? ", " : "");
                    strBuilder.append((Object)(biome != null ? biome.toString() : rl));
                });
                bioBWList = reservoir.getBiomes().isBlacklist() ? I18n.get((String)"ie.manual.entry.reservoirs.bio.invalid", (Object[])new Object[]{strBuilder.toString()}) : I18n.get((String)"ie.manual.entry.reservoirs.bio.valid", (Object[])new Object[]{strBuilder.toString()});
            } else {
                bioBWList = I18n.get((String)"ie.manual.entry.reservoirs.bio.any", (Object[])new Object[0]);
            }
            String fluidName = "";
            Fluid fluid = reservoir.getFluid();
            if (fluid != null) {
                fluidName = new FluidStack(fluid, 1).getHoverName().getString();
            }
            String repRate = "";
            if (reservoir.residual > 0) {
                repRate = reservoir.equilibrium > 0 ? I18n.get((String)"ie.manual.entry.reservoirs.replenish", (Object[])new Object[]{reservoir.residual, fluidName, Utils.fDecimal(reservoir.equilibrium / 1000)}) : I18n.get((String)"ie.manual.entry.reservoirs.replenish_depleted", (Object[])new Object[]{reservoir.residual, fluidName});
            }
            contentBuilder.append("<&").append(reservoir.getType().toString()).append(">");
            contentBuilder.append(I18n.get((String)"ie.manual.entry.reservoirs.content", (Object[])new Object[]{dimBWList, fluidName, Utils.fDecimal(reservoir.minSize / 1000), Utils.fDecimal(reservoir.maxSize / 1000), repRate, bioBWList}));
            if (i < reservoirs.length - 1) {
                contentBuilder.append("<np>");
            }
            itemList.add(new ManualEntry.SpecialElementData(reservoir.getType().toString(), 0, (SpecialManualElement)new ManualElementItem(ManualHelper.getManual(), new ItemStack[]{new ItemStack((ItemLike)fluid.getBucket())})));
        }
    }
}

