/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.reservoir;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import flaxbeard.immersivepetroleum.api.crafting.IPRecipeTypes;
import flaxbeard.immersivepetroleum.common.crafting.Serializers;
import flaxbeard.immersivepetroleum.common.util.RegistryUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import malte0811.dualcodecs.DualCodec;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.util.Lazy;

public class ReservoirType
extends IESerializableRecipe {
    static final Lazy<ItemStack> EMPTY_LAZY = Lazy.of(() -> ItemStack.EMPTY);
    static final TagOutput EMPTY = new TagOutput(ItemStack.EMPTY);
    public static Map<ResourceLocation, RecipeHolder<ReservoirType>> map = new HashMap<ResourceLocation, RecipeHolder<ReservoirType>>();
    public final String name;
    public final ResourceLocation fluidLocation;
    public final int weight;
    public final int minSize;
    public final int maxSize;
    public final int residual;
    public final int equilibrium;
    private final Fluid fluid;
    private BWList biomes = new BWList(false);
    private BWList dimensions = new BWList(false);

    public ReservoirType(String name, ResourceLocation fluidLocation, int minSize, int maxSize, int residual, int equilibrium, int weight) {
        this(name, (Fluid)BuiltInRegistries.FLUID.get(fluidLocation), minSize, maxSize, residual, equilibrium, weight);
    }

    public ReservoirType(String name, Fluid fluid, int minSize, int maxSize, int residual, int equilibrium, int weight) {
        super(EMPTY, IPRecipeTypes.RESERVOIR);
        this.name = name;
        this.fluidLocation = RegistryUtils.getRegistryNameOf(fluid);
        this.fluid = fluid;
        this.residual = residual;
        this.equilibrium = equilibrium;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.weight = weight;
    }

    public ReservoirType(CompoundTag nbt) {
        super(EMPTY, IPRecipeTypes.RESERVOIR);
        this.name = nbt.getString("name");
        this.fluidLocation = ResourceLocation.parse((String)nbt.getString("fluid"));
        this.fluid = (Fluid)BuiltInRegistries.FLUID.get(this.fluidLocation);
        this.minSize = nbt.getInt("minSize");
        this.maxSize = nbt.getInt("maxSize");
        this.residual = nbt.getInt("residual");
        this.equilibrium = nbt.getInt("equilibrium");
        this.biomes = new BWList(nbt.getCompound("biomes"));
        this.dimensions = new BWList(nbt.getCompound("dimensions"));
        this.weight = nbt.getInt("weight");
    }

    protected IERecipeSerializer<ReservoirType> getIESerializer() {
        return (IERecipeSerializer)Serializers.RESERVOIR_SERIALIZER.get();
    }

    public CompoundTag writeToNBT() {
        return this.writeToNBT(new CompoundTag());
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        nbt.putString("name", this.name);
        nbt.putString("id", this.type.toString());
        nbt.putString("fluid", this.fluidLocation.toString());
        nbt.putInt("minSize", this.minSize);
        nbt.putInt("maxSize", this.maxSize);
        nbt.putInt("residual", this.residual);
        nbt.putInt("equilibrium", this.equilibrium);
        nbt.put("biomes", (Tag)this.biomes.toNbt());
        nbt.put("dimensions", (Tag)this.dimensions.toNbt());
        nbt.putInt("weight", this.weight);
        return nbt;
    }

    public void setBiomes(BWList.Mode mode, ResourceLocation ... names) {
        this.setBiomes(mode, Arrays.asList(names));
    }

    public void setBiomes(BWList.Mode mode, List<ResourceLocation> names) {
        this.setBiomes(new BWList(new HashSet<ResourceLocation>(names), mode));
    }

    public void setBiomes(boolean blacklist, ResourceLocation ... names) {
        this.setBiomes(blacklist, Arrays.asList(names));
    }

    public void setBiomes(boolean blacklist, List<ResourceLocation> names) {
        this.setBiomes(new BWList(new HashSet<ResourceLocation>(names), blacklist));
    }

    public void setBiomes(@Nonnull BWList list) {
        Objects.requireNonNull(list);
        this.biomes = list;
    }

    public void setDimensions(BWList.Mode mode, ResourceLocation ... names) {
        this.setDimensions(mode, Arrays.asList(names));
    }

    public void setDimensions(BWList.Mode mode, List<ResourceLocation> names) {
        this.setDimensions(new BWList(new HashSet<ResourceLocation>(names), mode));
    }

    public void setDimensions(boolean blacklist, ResourceLocation ... names) {
        this.setDimensions(blacklist, Arrays.asList(names));
    }

    public void setDimensions(boolean blacklist, List<ResourceLocation> names) {
        this.setDimensions(new BWList(new HashSet<ResourceLocation>(names), blacklist));
    }

    public void setDimensions(@Nonnull BWList list) {
        Objects.requireNonNull(list);
        this.dimensions = list;
    }

    public Set<ResourceLocation> getBiomeList() {
        return this.biomes.getSet();
    }

    public Set<ResourceLocation> getDimensionList() {
        return this.dimensions.getSet();
    }

    public BWList getDimensions() {
        return this.dimensions;
    }

    public BWList getBiomes() {
        return this.biomes;
    }

    @Nonnull
    public ItemStack getResultItem(@Nonnull HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public String toString() {
        return this.writeToNBT().toString();
    }

    static Set<ResourceLocation> toSet(ListTag nbtList) {
        HashSet<ResourceLocation> set = new HashSet<ResourceLocation>();
        if (!nbtList.isEmpty()) {
            nbtList.forEach(tag -> {
                if (tag instanceof StringTag) {
                    set.add(ResourceLocation.parse((String)tag.getAsString()));
                }
            });
        }
        return set;
    }

    static ListTag toNbt(Set<ResourceLocation> set) {
        ListTag nbtList = new ListTag();
        if (!set.isEmpty()) {
            set.forEach(rl -> nbtList.add((Object)StringTag.valueOf((String)rl.toString())));
        }
        return nbtList;
    }

    public static class BWList {
        public static final Codec<BWList> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.CODEC.listOf().fieldOf("list").xmap(resourceLocations -> {
            HashSet set = new HashSet(resourceLocations.size());
            set.addAll(resourceLocations);
            return set;
        }, ArrayList::new).forGetter(BWList::getSet), (App)Codec.BOOL.fieldOf("isBlacklist").forGetter(BWList::isBlacklist)).apply((Applicative)inst, BWList::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BWList> CODEC_STREAM = new StreamCodec<RegistryFriendlyByteBuf, BWList>(){

            @Nonnull
            public BWList decode(RegistryFriendlyByteBuf buf) {
                int size = buf.readInt();
                HashSet<ResourceLocation> set = new HashSet<ResourceLocation>();
                for (int i = 0; i < size; ++i) {
                    set.add((ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buf));
                }
                boolean isBlacklist = buf.readBoolean();
                return new BWList(set, isBlacklist);
            }

            public void encode(RegistryFriendlyByteBuf buf, BWList bwList) {
                buf.writeInt(bwList.set.size());
                bwList.set.forEach(rl -> ResourceLocation.STREAM_CODEC.encode((Object)buf, rl));
                buf.writeBoolean(bwList.isBlacklist());
            }
        };
        public static final DualCodec<RegistryFriendlyByteBuf, BWList> CODECS = new DualCodec(CODEC, CODEC_STREAM);
        private final Set<ResourceLocation> set;
        private final Mode mode;

        public BWList(boolean isBlacklist) {
            this(new HashSet<ResourceLocation>(), isBlacklist);
        }

        public BWList(Set<ResourceLocation> set, boolean isBlacklist) {
            this(set, isBlacklist ? Mode.BLACKLIST : Mode.WHITELIST);
        }

        public BWList(Set<ResourceLocation> set, Mode mode) {
            this.set = set;
            this.mode = mode;
        }

        public BWList(CompoundTag tag) {
            Mode mode = this.mode = tag.getBoolean("isBlacklist") ? Mode.BLACKLIST : Mode.WHITELIST;
            if (tag.contains("list", 9)) {
                ListTag list = tag.getList("list", 8);
                HashSet<ResourceLocation> set = new HashSet<ResourceLocation>();
                if (!list.isEmpty()) {
                    list.forEach(t -> {
                        if (t instanceof StringTag) {
                            set.add(ResourceLocation.parse((String)t.getAsString()));
                        }
                    });
                }
                this.set = set;
            } else {
                this.set = new HashSet<ResourceLocation>();
            }
        }

        public boolean isBlacklist() {
            return this.mode == Mode.BLACKLIST;
        }

        public boolean add(ResourceLocation rl) {
            return this.set.add(rl);
        }

        public boolean addAll(Collection<? extends ResourceLocation> c) {
            return this.set.addAll(c);
        }

        public boolean hasEntries() {
            return !this.set.isEmpty();
        }

        public boolean valid(ResourceLocation rl) {
            if (this.set.isEmpty()) {
                return true;
            }
            boolean contains = this.set.contains(rl);
            return this.isBlacklist() ? !contains : contains;
        }

        public Set<ResourceLocation> getSet() {
            return Collections.unmodifiableSet(this.set);
        }

        public void forEach(Consumer<ResourceLocation> action) {
            this.set.forEach(action);
        }

        public CompoundTag toNbt() {
            CompoundTag tag = new CompoundTag();
            tag.putBoolean("isBlacklist", this.mode == Mode.BLACKLIST);
            tag.put("list", (Tag)this.toNbtList());
            return tag;
        }

        private ListTag toNbtList() {
            ListTag nbtList = new ListTag();
            if (this.hasEntries()) {
                this.set.forEach((? super T rl) -> nbtList.add((Object)StringTag.valueOf((String)rl.toString())));
            }
            return nbtList;
        }

        public static enum Mode {
            WHITELIST,
            BLACKLIST;

        }
    }
}

