/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.reservoir;

import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirBoundingBox;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.world.level.Level;

public class ReservoirPolygon {
    private final ArrayList<ColumnPos> poly = new ArrayList();
    private final ReservoirBoundingBox bounds;

    public static ReservoirPolygon make(Level level, ColumnPos start) {
        return new ReservoirPolygon(level, start);
    }

    public static ReservoirPolygon fromNBT(CompoundTag tag) {
        return new ReservoirPolygon(tag);
    }

    ReservoirPolygon(Level level, ColumnPos start) {
        HashSet<Location> TEMP = new HashSet<Location>(2600);
        this.scan(level, start, TEMP);
        TEMP.removeIf(location -> !location.edge());
        this.makeDirectional(TEMP);
        this.cullLines();
        this.poly.trimToSize();
        this.bounds = this.createBoundingBox();
    }

    ReservoirBoundingBox createBoundingBox() {
        int xMin = Integer.MAX_VALUE;
        int zMin = Integer.MAX_VALUE;
        int xMax = Integer.MIN_VALUE;
        int zMax = Integer.MIN_VALUE;
        for (ColumnPos p : this.poly) {
            if (p.x() < xMin) {
                xMin = p.x();
            }
            if (p.z() < zMin) {
                zMin = p.z();
            }
            if (p.x() > xMax) {
                xMax = p.x();
            }
            if (p.z() <= zMax) continue;
            zMax = p.z();
        }
        return new ReservoirBoundingBox(xMin, zMin, xMax, zMax);
    }

    ReservoirPolygon(CompoundTag nbt) {
        int xMin = nbt.getInt("xMin");
        int zMin = nbt.getInt("zMin");
        int xMax = nbt.getInt("xMax");
        int zMax = nbt.getInt("zMax");
        this.bounds = new ReservoirBoundingBox(xMin, zMin, xMax, zMax);
        byte[] array = nbt.getByteArray("points");
        for (int i = 0; i < array.length; i += 2) {
            int x = this.bounds.xMin() + (array[i] & 0xFF);
            int z = this.bounds.zMin() + (array[i + 1] & 0xFF);
            this.poly.add(new ColumnPos(x, z));
        }
    }

    public CompoundTag writeToNBT() {
        CompoundTag tag = new CompoundTag();
        ReservoirBoundingBox bounds = this.getBoundingBox();
        tag.putInt("xMin", bounds.xMin());
        tag.putInt("zMin", bounds.zMin());
        tag.putInt("xMax", bounds.xMax());
        tag.putInt("zMax", bounds.zMax());
        byte[] array = new byte[this.poly.size() * 2];
        int i = 0;
        int j = 0;
        while (i < this.poly.size()) {
            ColumnPos pos = this.poly.get(i);
            byte x = (byte)(pos.x() - bounds.xMin() & 0xFF);
            byte z = (byte)(pos.z() - bounds.zMin() & 0xFF);
            array[j] = x;
            array[j + 1] = z;
            ++i;
            j += 2;
        }
        tag.putByteArray("points", array);
        return tag;
    }

    @Deprecated
    public List<ColumnPos> getPolygonList() {
        return Collections.unmodifiableList(this.poly);
    }

    public boolean isEmpty() {
        return this.poly.isEmpty();
    }

    public ReservoirBoundingBox getBoundingBox() {
        return this.bounds;
    }

    public boolean contains(ColumnPos pos) {
        return this.contains(pos.x(), pos.z());
    }

    public boolean contains(int x, int z) {
        if (!this.bounds.contains(x, z)) {
            return false;
        }
        return this.polygonContains(x, z);
    }

    public boolean polygonContains(ColumnPos pos) {
        return this.polygonContains(pos.x(), pos.z());
    }

    public boolean polygonContains(int x, int z) {
        boolean ret = false;
        int j = this.poly.size() - 1;
        int i = 0;
        while (i < this.poly.size()) {
            ColumnPos a = this.poly.get(i);
            ColumnPos b = this.poly.get(j);
            float ax = a.x();
            float az = a.z();
            float bx = b.x();
            float bz = b.z();
            if (ax == (float)x && az == (float)z) {
                return true;
            }
            if (ax == (float)x && bx == (float)x && ((float)z > bz && (float)z < az || (float)z > az && (float)z < bz)) {
                return true;
            }
            if (az == (float)z && bz == (float)z && ((float)x > ax && (float)x < bx || (float)x > bx && (float)x < ax)) {
                return true;
            }
            if ((az < (float)z && bz >= (float)z || bz < (float)z && az >= (float)z) && (ax <= (float)x || bx <= (float)x)) {
                float f0 = ax + ((float)z - az) / (bz - az) * (bx - ax);
                ret ^= f0 < (float)x;
            }
            j = i++;
        }
        return ret;
    }

    void makeDirectional(Set<Location> TEMP) {
        Location current = (Location)TEMP.stream().findFirst().get();
        TEMP.remove(current);
        ArrayList<Location> dst = new ArrayList<Location>();
        dst.add(current);
        while (!TEMP.isEmpty()) {
            if ((current = ReservoirPolygon.nextDir(TEMP, current, dst)) != null) continue;
            if (TEMP.isEmpty()) break;
            ImmersivePetroleum.log.warn("Early-Exit: ReservoirPolygon.TEMP is not Empty! Still containing {}", (Object)TEMP.size());
            break;
        }
        this.poly.addAll(dst.stream().map(Location::pos).toList());
    }

    void cullLines() {
        int endIndex = 0;
        ColumnPos endPos = null;
        for (int startIndex = 0; startIndex < this.poly.size(); ++startIndex) {
            int dz;
            int dx;
            ColumnPos pos;
            int index;
            int j;
            ColumnPos startPos = this.poly.get(startIndex);
            for (j = 1; j < 64; ++j) {
                index = (startIndex + j) % this.poly.size();
                pos = this.poly.get(index);
                if (startPos.z() != pos.z()) break;
                endIndex = index;
                endPos = pos;
            }
            for (j = 1; j < 64; ++j) {
                index = (startIndex + j) % this.poly.size();
                pos = this.poly.get(index);
                if (startPos.x() != pos.x()) break;
                endIndex = index;
                endPos = pos;
            }
            for (j = 1; j < 64 && (dx = Math.abs((pos = this.poly.get(index = (startIndex + j) % this.poly.size())).x() - startPos.x())) == (dz = Math.abs(pos.z() - startPos.z())); ++j) {
                endIndex = index;
                endPos = pos;
            }
            if (endPos == null) continue;
            int len = endIndex - startIndex;
            if (len > 1) {
                for (int j2 = index = startIndex + 1; j2 < endIndex; ++j2) {
                    this.poly.remove(index % this.poly.size());
                }
            } else if (len < 0 && (len = len + this.poly.size() - 1) > 1) {
                index = startIndex + 1;
                for (int j3 = 0; j3 < len; ++j3) {
                    this.poly.remove(index % this.poly.size());
                }
            }
            endPos = null;
        }
    }

    static Location nextDir(Set<Location> TEMP, Location current, List<Location> dst) {
        Location[] locations;
        for (Location location : locations = new Location[]{current.offset(1, 0), current.offset(-1, 0), current.offset(0, 1), current.offset(0, -1), current.offset(-1, -1), current.offset(-1, 1), current.offset(1, -1), current.offset(1, 1)}) {
            if (!TEMP.remove(location)) continue;
            dst.add(location);
            return location;
        }
        return null;
    }

    void scan(Level level, ColumnPos pos, Set<Location> TEMP) {
        if (TEMP.contains(new Location(pos, false)) || ReservoirHandler.getValueOf(level, pos.x(), pos.z()) == -1.0) {
            return;
        }
        ColumnPos p0 = new ColumnPos(pos.x() + 1, pos.z());
        ColumnPos p1 = new ColumnPos(pos.x() - 1, pos.z());
        ColumnPos p2 = new ColumnPos(pos.x(), pos.z() + 1);
        ColumnPos p3 = new ColumnPos(pos.x(), pos.z() - 1);
        boolean b0 = ReservoirHandler.getValueOf(level, p0.x(), p0.z()) == -1.0;
        boolean b1 = ReservoirHandler.getValueOf(level, p1.x(), p1.z()) == -1.0;
        boolean b2 = ReservoirHandler.getValueOf(level, p2.x(), p2.z()) == -1.0;
        boolean b3 = ReservoirHandler.getValueOf(level, p3.x(), p3.z()) == -1.0;
        TEMP.add(new Location(pos, b0 | b1 | b2 | b3));
        this.scan(level, p0, TEMP);
        this.scan(level, p1, TEMP);
        this.scan(level, p2, TEMP);
        this.scan(level, p3, TEMP);
    }

    private record Location(@Nonnull ColumnPos pos, boolean edge) {
        public Location(int x, int z, boolean edge) {
            this(new ColumnPos(x, z), edge);
        }

        public Location offset(int x, int z) {
            return new Location(this.pos.x() + x, this.pos.z() + z, false);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Location)) {
                return false;
            }
            Location other = (Location)o;
            return Objects.equals(this.pos, other.pos);
        }

        @Override
        public int hashCode() {
            return this.pos.hashCode();
        }
    }
}

