/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.reservoir;

import com.google.common.collect.ImmutableList;
import flaxbeard.immersivepetroleum.api.reservoir.Reservoir;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirType;
import flaxbeard.immersivepetroleum.common.datastorage.reservoir.ReservoirRegionDataStorage;
import flaxbeard.immersivepetroleum.common.util.Utils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import org.apache.commons.lang3.tuple.Pair;

public class ReservoirHandler {
    private static final Map<Pair<ResourceKey<Level>, ColumnPos>, Reservoir> CACHE = new HashMap<Pair<ResourceKey<Level>, ColumnPos>, Reservoir>();
    private static final Map<ResourceLocation, Map<ResourceLocation, Integer>> totalWeightMap = new HashMap<ResourceLocation, Map<ResourceLocation, Integer>>();
    private static long lastSeed;
    private static PerlinSimplexNoise generator;
    static final double scale = 0.015625;
    static final double d0 = 0.6666666666666666;
    static final double d1 = 0.3333333333333333;

    public static int getTotalWeight(ResourceLocation dimension, ResourceLocation biome) {
        Map map = totalWeightMap.computeIfAbsent(dimension, k -> new HashMap());
        return map.computeIfAbsent(biome, biomeRL -> {
            int totalWeight = 0;
            for (RecipeHolder<ReservoirType> holder : ReservoirType.map.values()) {
                ReservoirType reservoir = (ReservoirType)holder.value();
                if (!reservoir.getDimensions().valid(dimension) || !reservoir.getBiomes().valid(biome)) continue;
                totalWeight += reservoir.weight;
            }
            return totalWeight;
        });
    }

    public static Reservoir getReservoir(Level world, BlockPos pos) {
        return ReservoirHandler.getReservoir(world, Utils.toColumnPos(pos));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Reservoir getReservoir(Level world, ColumnPos pos) {
        if (world.isClientSide) {
            return null;
        }
        ResourceKey dimension = world.dimension();
        Pair cacheKey = Pair.of((Object)dimension, (Object)pos);
        Map<Pair<ResourceKey<Level>, ColumnPos>, Reservoir> map = CACHE;
        synchronized (map) {
            Reservoir ret = CACHE.get(cacheKey);
            if (ret == null) {
                Reservoir reservoir = ReservoirRegionDataStorage.get().getReservoir(world, pos);
                CACHE.put((Pair<ResourceKey<Level>, ColumnPos>)cacheKey, reservoir);
                return reservoir;
            }
            return ret;
        }
    }

    public static Reservoir getReservoirNoCache(Level world, BlockPos pos) {
        return ReservoirHandler.getReservoirNoCache(world, Utils.toColumnPos(pos));
    }

    public static Reservoir getReservoirNoCache(Level world, ColumnPos pos) {
        if (world.isClientSide) {
            return null;
        }
        return ReservoirRegionDataStorage.get().getReservoir(world, pos);
    }

    public static RecipeHolder<ReservoirType> addReservoir(ResourceLocation id, RecipeHolder<ReservoirType> reservoir) {
        ReservoirType.map.put(id, reservoir);
        return reservoir;
    }

    public static double getValueOf(@Nonnull Level level, int x, int z) {
        double noise;
        if (!level.isClientSide && level instanceof WorldGenLevel) {
            WorldGenLevel worldGen = (WorldGenLevel)level;
            ReservoirHandler.initGenerator(worldGen);
        }
        if ((noise = Math.abs(generator.getValue((double)x * 0.015625, (double)z * 0.015625, false))) > 0.6666666666666666) {
            return (noise - 0.6666666666666666) / 0.3333333333333333;
        }
        return -1.0;
    }

    public static void initGenerator(WorldGenLevel world) {
        if (generator == null || world.getSeed() != lastSeed) {
            lastSeed = world.getSeed();
            generator = new PerlinSimplexNoise((RandomSource)new WorldgenRandom((RandomSource)new LegacyRandomSource(lastSeed)), (List)ImmutableList.of((Object)0));
        }
    }

    public static PerlinSimplexNoise getGenerator() {
        return generator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Map<Pair<ResourceKey<Level>, ColumnPos>, Reservoir> map = CACHE;
        synchronized (map) {
            CACHE.clear();
        }
    }

    public static void recalculateChances() {
        totalWeightMap.clear();
    }
}

