/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import flaxbeard.immersivepetroleum.api.crafting.IPRecipeTypes;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirHandler;
import flaxbeard.immersivepetroleum.client.ClientProxy;
import flaxbeard.immersivepetroleum.common.CommonEventHandler;
import flaxbeard.immersivepetroleum.common.CommonProxy;
import flaxbeard.immersivepetroleum.common.ExternalModContent;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.IPRegisters;
import flaxbeard.immersivepetroleum.common.IPSaveData;
import flaxbeard.immersivepetroleum.common.cfg.IPClientConfig;
import flaxbeard.immersivepetroleum.common.cfg.IPServerConfig;
import flaxbeard.immersivepetroleum.common.crafting.RecipeReloadListener;
import flaxbeard.immersivepetroleum.common.datastorage.reservoir.ReservoirRegionDataStorage;
import flaxbeard.immersivepetroleum.common.network.IPPacketHandler;
import flaxbeard.immersivepetroleum.common.util.commands.IslandCommand;
import flaxbeard.immersivepetroleum.common.util.loot.IPLootFunctions;
import java.util.function.Supplier;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="immersivepetroleum")
public class ImmersivePetroleum {
    public static final String MODID = "immersivepetroleum";
    public static final Logger log = LogManager.getLogger((String)"immersivepetroleum");
    public static final CommonProxy proxy = ImmersivePetroleum.proxy(() -> FMLLoader.getDist().isClient() ? new ClientProxy() : new CommonProxy());

    private static CommonProxy proxy(Supplier<CommonProxy> proxy) {
        return proxy.get();
    }

    public ImmersivePetroleum(ModContainer container, Dist dist, IEventBus eBus) {
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)IPServerConfig.ALL);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)IPClientConfig.ALL);
        eBus.addListener(this::setup);
        eBus.addListener(this::loadComplete);
        NeoForge.EVENT_BUS.addListener(this::worldLoad);
        NeoForge.EVENT_BUS.addListener(this::serverStarting);
        NeoForge.EVENT_BUS.addListener(this::registerCommand);
        NeoForge.EVENT_BUS.addListener(this::addReloadListeners);
        eBus.addListener(this::networking);
        eBus.addListener(this::registerMenuScreens);
        IPRegisters.addRegistersToEventBus(eBus);
        IPContent.modConstruction(eBus);
        IPRegisters.runCallbacks(eBus);
        IPLootFunctions.modConstruction(eBus);
        IPRecipeTypes.modConstruction(eBus);
    }

    private void setup(FMLCommonSetupEvent event) {
        NeoForge.EVENT_BUS.register((Object)new CommonEventHandler());
        proxy.setup(event);
        IPContent.setup(event);
        ExternalModContent.setup(event);
        ReservoirHandler.recalculateChances();
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        proxy.completed(event);
    }

    private void registerMenuScreens(RegisterMenuScreensEvent ev) {
        proxy.registerContainersAndScreens(ev);
    }

    private void registerCommand(RegisterCommandsEvent event) {
        LiteralArgumentBuilder ip = Commands.literal((String)"ip");
        ip.then(IslandCommand.create());
        event.getDispatcher().register(ip);
    }

    private void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new RecipeReloadListener(event.getServerResources()));
    }

    private void worldLoad(LevelEvent.Load event) {
        ServerLevel world;
        LevelAccessor levelAccessor;
        if (!event.getLevel().isClientSide() && (levelAccessor = event.getLevel()) instanceof ServerLevel && (world = (ServerLevel)levelAccessor).dimension() == Level.OVERWORLD) {
            DimensionDataStorage dimData = world.getDataStorage();
            ReservoirRegionDataStorage.init(dimData);
            dimData.computeIfAbsent(new SavedData.Factory(IPSaveData::new, IPSaveData::new), "ImmersivePetroleum-SaveData");
        }
    }

    private void serverStarting(ServerStartingEvent event) {
        ReservoirHandler.recalculateChances();
    }

    private void networking(RegisterPayloadHandlersEvent event) {
        IPPacketHandler.init(event.registrar(MODID));
    }
}

