/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.sound;

import blusunrize.immersiveengineering.api.tool.INoisyTool;
import blusunrize.immersiveengineering.common.network.MessageNoisyToolAttack;
import blusunrize.immersiveengineering.common.network.MessageNoisyToolHarvestUpdate;
import blusunrize.immersiveengineering.common.util.sound.NoisyToolSoundGroup;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="immersiveengineering", bus=EventBusSubscriber.Bus.GAME)
public class NoisyToolSoundHandler {
    private static final Map<LivingEntity, Map<EquipmentSlot, NoisyToolSoundGroup>> noisyToolSoundGroups = new HashMap<LivingEntity, Map<EquipmentSlot, NoisyToolSoundGroup>>();

    private static Map<EquipmentSlot, NoisyToolSoundGroup> getSafeNTSGs(LivingEntity entity) {
        Map<EquipmentSlot, NoisyToolSoundGroup> result = noisyToolSoundGroups.get(entity);
        if (result != null) {
            return result;
        }
        if (INoisyTool.isAbleNoisyTool(entity.getMainHandItem()) || INoisyTool.isAbleNoisyTool(entity.getOffhandItem())) {
            result = new HashMap<EquipmentSlot, NoisyToolSoundGroup>();
            noisyToolSoundGroups.put(entity, result);
        }
        return result;
    }

    @Nullable
    public static NoisyToolSoundGroup getSafeNTSG(LivingEntity entity, EquipmentSlot slot) {
        int hotbarSlot;
        assert (slot.getType().equals((Object)EquipmentSlot.Type.HAND));
        Map<EquipmentSlot, NoisyToolSoundGroup> ntsgs = NoisyToolSoundHandler.getSafeNTSGs(entity);
        if (ntsgs == null) {
            return null;
        }
        NoisyToolSoundGroup soundGroup = ntsgs.get(slot);
        ItemStack handItem = entity.getItemBySlot(slot);
        if (slot.equals((Object)EquipmentSlot.MAINHAND) && entity instanceof Player) {
            Player player = (Player)entity;
            v0 = player.getInventory().selected;
        } else {
            v0 = hotbarSlot = -1;
        }
        if (soundGroup != null) {
            if (!soundGroup.checkItemValid(handItem, hotbarSlot)) {
                ntsgs.remove(slot);
                soundGroup = null;
                if (ntsgs.isEmpty()) {
                    noisyToolSoundGroups.remove(entity);
                }
            }
        } else if (INoisyTool.isAbleNoisyTool(handItem)) {
            soundGroup = new NoisyToolSoundGroup(handItem, entity, hotbarSlot);
            ntsgs.put(slot, soundGroup);
        }
        return soundGroup;
    }

    public static void handleHarvestAction(LivingEntity noisyToolHolder, PlayerInteractEvent.LeftClickBlock.Action action, BlockPos targetBlockPos) {
        NoisyToolSoundGroup ntsg = NoisyToolSoundHandler.getSafeNTSG(noisyToolHolder, EquipmentSlot.MAINHAND);
        if (ntsg != null) {
            switch (action) {
                case START: {
                    ntsg.updateHarvestState(targetBlockPos);
                    break;
                }
                case STOP: 
                case ABORT: {
                    ntsg.updateHarvestState(null);
                    break;
                }
                case CLIENT_HOLD: {
                    ntsg.updateHarvestState(targetBlockPos);
                }
            }
        }
    }

    public static void handleAttack(LivingEntity noisyToolHolder) {
        NoisyToolSoundGroup ntsg = NoisyToolSoundHandler.getSafeNTSG(noisyToolHolder, EquipmentSlot.MAINHAND);
        if (ntsg != null) {
            ntsg.triggerAttack();
        }
    }

    @SubscribeEvent
    public static void toolHeldCheck(EntityTickEvent.Post ev) {
        Entity entity = ev.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity noisyToolHolder = (LivingEntity)entity;
            if (!noisyToolHolder.level().isClientSide()) {
                return;
            }
            NoisyToolSoundGroup ntsgMainHand = NoisyToolSoundHandler.getSafeNTSG(noisyToolHolder, EquipmentSlot.MAINHAND);
            NoisyToolSoundGroup ntsgOffHand = NoisyToolSoundHandler.getSafeNTSG(noisyToolHolder, EquipmentSlot.OFFHAND);
            if (ntsgMainHand != null) {
                ntsgMainHand.switchMotorOnOff(true);
            }
            if (ntsgOffHand != null) {
                ntsgOffHand.switchMotorOnOff(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void harvestCheck(PlayerInteractEvent.LeftClickBlock ev) {
        if (INoisyTool.isAbleNoisyTool(ev.getItemStack())) {
            Player player;
            Player noisyToolHolder = ev.getEntity();
            if (noisyToolHolder instanceof Player && (player = noisyToolHolder).isCreative()) {
                return;
            }
            BlockPos targetPos = ev.getPos();
            if (ev.getLevel().isClientSide() && noisyToolHolder.equals((Object)Minecraft.getInstance().player)) {
                NoisyToolSoundHandler.handleHarvestAction((LivingEntity)noisyToolHolder, ev.getAction(), targetPos);
            } else {
                PacketDistributor.sendToPlayersTrackingEntity((Entity)noisyToolHolder, (CustomPacketPayload)new MessageNoisyToolHarvestUpdate((LivingEntity)noisyToolHolder, ev.getAction(), targetPos), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void clientSideAttackCheck(AttackEntityEvent ev) {
        Player player;
        if (ev.getTarget() instanceof LivingEntity && (player = ev.getEntity()).level().isClientSide() && INoisyTool.isAbleNoisyTool(player.getItemBySlot(EquipmentSlot.MAINHAND))) {
            NoisyToolSoundHandler.handleAttack((LivingEntity)player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void serverSideAttackCheck(LivingIncomingDamageEvent ev) {
        LivingEntity noisyToolHolder;
        Entity entity = ev.getSource().getEntity();
        if (entity instanceof LivingEntity && INoisyTool.isAbleNoisyTool((noisyToolHolder = (LivingEntity)entity).getItemBySlot(EquipmentSlot.MAINHAND))) {
            PacketDistributor.sendToPlayersTrackingEntity((Entity)noisyToolHolder, (CustomPacketPayload)new MessageNoisyToolAttack(noisyToolHolder), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void stopLeavingSoundSource(EntityLeaveLevelEvent ev) {
        LivingEntity livingEntity;
        Map<EquipmentSlot, NoisyToolSoundGroup> ntsgs;
        Object object;
        if (ev.getLevel().isClientSide() && (object = ev.getEntity()) instanceof LivingEntity && (ntsgs = noisyToolSoundGroups.remove(livingEntity = (LivingEntity)object)) != null) {
            for (NoisyToolSoundGroup ntsg : ntsgs.values()) {
                ntsg.switchMotorOnOff(false);
            }
        }
    }

    @SubscribeEvent
    public static void leaveLevel(LevelEvent.Unload ev) {
        noisyToolSoundGroups.clear();
    }
}

