/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class BlockEntityInventory
implements Container {
    final BlockEntity tile;
    final IIEInventory inv;
    final AbstractContainerMenu eventHandler;

    public BlockEntityInventory(BlockEntity tile, AbstractContainerMenu eventHandler) {
        this.tile = tile;
        this.inv = (IIEInventory)tile;
        this.eventHandler = eventHandler;
    }

    public int getContainerSize() {
        return this.inv.getInventory().size();
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.inv.getInventory()) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.inv.getInventory().get(index);
    }

    public ItemStack removeItem(int index, int count) {
        ItemStack stack = (ItemStack)this.inv.getInventory().get(index);
        if (!stack.isEmpty()) {
            if (stack.getCount() <= count) {
                this.inv.getInventory().set(index, (Object)ItemStack.EMPTY);
            } else if ((stack = stack.split(count)).getCount() == 0) {
                this.inv.getInventory().set(index, (Object)ItemStack.EMPTY);
            }
            this.eventHandler.slotsChanged((Container)this);
        }
        return stack;
    }

    public ItemStack removeItemNoUpdate(int index) {
        ItemStack ret = ((ItemStack)this.inv.getInventory().get(index)).copy();
        this.inv.getInventory().set(index, (Object)ItemStack.EMPTY);
        return ret;
    }

    public void setItem(int index, ItemStack stack) {
        this.inv.getInventory().set(index, (Object)stack);
        this.eventHandler.slotsChanged((Container)this);
    }

    public int getMaxStackSize() {
        return 64;
    }

    public void setChanged() {
        this.tile.setChanged();
    }

    public boolean stillValid(Player player) {
        return BlockEntityInventory.isValidForPlayer(this.tile, player);
    }

    public static boolean isValidForPlayer(BlockEntity bEntity, Player player) {
        IEBlockInterfaces.IInteractionObjectIE interactionObject;
        if (bEntity instanceof IEBlockInterfaces.IInteractionObjectIE && !(interactionObject = (IEBlockInterfaces.IInteractionObjectIE)bEntity).canUseGui(player)) {
            return false;
        }
        return !bEntity.isRemoved() && Vec3.atCenterOf((Vec3i)bEntity.getBlockPos()).distanceToSqr(player.position()) < 64.0;
    }

    public void startOpen(Player player) {
    }

    public void stopOpen(Player player) {
        this.inv.doGraphicalUpdates();
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return this.inv.isStackValid(index, stack);
    }

    public void clearContent() {
        for (int i = 0; i < this.inv.getInventory().size(); ++i) {
            this.inv.getInventory().set(i, (Object)ItemStack.EMPTY);
        }
    }
}

