/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.tool.MachineInterfaceHandler;
import blusunrize.immersiveengineering.api.wires.redstone.CapabilityRedstoneNetwork;
import blusunrize.immersiveengineering.common.blocks.BlockCapabilityRegistration;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.IEBlockCapabilityCaches;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MachineInterfaceBlockEntity
extends IEBaseBlockEntity
implements IEServerTickableBE,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IRedstoneOutput {
    public final IEBlockCapabilityCaches.IEBlockCapabilityCache<MachineInterfaceHandler.IMachineInterfaceConnection> machine = IEBlockCapabilityCaches.forNeighbor(MachineInterfaceHandler.IMachineInterfaceConnection.CAPABILITY, this, this::getFacing);
    public List<MachineInterfaceConfig<?>> configurations = new ArrayList();
    private final int[] outputs = new int[DyeColor.values().length];
    public DyeColor inputColor = DyeColor.WHITE;
    private byte inputSignalStrength = 0;
    private final CapabilityRedstoneNetwork.RedstoneBundleConnection redstoneCap = new CapabilityRedstoneNetwork.RedstoneBundleConnection(){

        @Override
        public void onChange(byte[] externalInputs, Direction side) {
            if (externalInputs[MachineInterfaceBlockEntity.this.inputColor.getId()] != MachineInterfaceBlockEntity.this.inputSignalStrength) {
                MachineInterfaceBlockEntity.this.inputSignalStrength = externalInputs[MachineInterfaceBlockEntity.this.inputColor.getId()];
                MachineInterfaceBlockEntity.this.markChunkDirty();
                MachineInterfaceBlockEntity.this.markContainingBlockForUpdate(MachineInterfaceBlockEntity.this.getBlockState());
            }
        }

        @Override
        public void updateInput(byte[] signals, Direction side) {
            for (DyeColor dye : DyeColor.values()) {
                signals[dye.getId()] = (byte)MachineInterfaceBlockEntity.this.outputs[dye.getId()];
            }
        }
    };

    public MachineInterfaceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.MACHINE_INTERFACE.get(), pos, state);
    }

    @Override
    public void tickServer() {
        MachineInterfaceHandler.IMachineInterfaceConnection machineCapability = this.machine.getCapability();
        if (machineCapability != null) {
            int[] outPre = Arrays.copyOf(this.outputs, this.outputs.length);
            Arrays.fill(this.outputs, 0);
            this.configurations.forEach(config -> {
                this.outputs[config.outputColor.getId()] = config.getValue(machineCapability);
            });
            if (!Arrays.equals(outPre, this.outputs)) {
                this.redstoneCap.markDirty();
            }
        } else if (!this.configurations.isEmpty()) {
            this.configurations.clear();
            this.markChunkDirty();
            this.markContainingBlockForUpdate(this.getBlockState());
        }
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        ListTag list = nbt.getList("configurations", 10);
        this.configurations.clear();
        for (int i = 0; i < list.size(); ++i) {
            this.configurations.add(MachineInterfaceConfig.readFromNBT(list.getCompound(i)));
        }
        this.inputColor = DyeColor.byId((int)nbt.getInt("inputColor"));
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        ListTag list = new ListTag();
        this.configurations.forEach(conf -> list.add((Object)conf.writeToNBT()));
        nbt.put("configurations", (Tag)list);
        nbt.putInt("inputColor", this.inputColor.getId());
    }

    @Override
    public void receiveMessageFromClient(CompoundTag message) {
        if (message.contains("configuration")) {
            int idx = message.getInt("idx");
            if (idx >= this.configurations.size()) {
                this.configurations.add(MachineInterfaceConfig.readFromNBT(message.getCompound("configuration")));
            } else {
                this.configurations.set(idx, MachineInterfaceConfig.readFromNBT(message.getCompound("configuration")));
            }
        } else if (message.getBoolean("delete")) {
            this.configurations.remove(message.getInt("idx"));
        } else if (message.contains("inputColor")) {
            this.inputColor = DyeColor.byId((int)message.getInt("inputColor"));
        }
        this.setChanged();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public ItemInteractionResult interact(Direction side, Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (this.getLevelNonnull().isClientSide) {
            ImmersiveEngineering.proxy.openTileScreen("machineinterface", this);
        }
        return ItemInteractionResult.sidedSuccess((boolean)this.getLevelNonnull().isClientSide);
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL_PREFER_SIDE;
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    public static void registerCapabilities(BlockCapabilityRegistration.BECapabilityRegistrar<MachineInterfaceBlockEntity> registrar) {
        registrar.register(CapabilityRedstoneNetwork.REDSTONE_BUNDLE_CONNECTION, (be, side) -> be.redstoneCap);
    }

    @Override
    public int getStrongRSOutput(Direction side) {
        return this.canConnectRedstone(side) ? this.inputSignalStrength : (byte)0;
    }

    @Override
    public boolean canConnectRedstone(Direction side) {
        return side == this.getFacing().getOpposite();
    }

    public static final class MachineInterfaceConfig<T> {
        private int selectedCheck;
        private int selectedOption;
        private DyeColor outputColor;

        public MachineInterfaceConfig(int selectedCheck, int selectedOption, DyeColor outputColor) {
            this.selectedCheck = selectedCheck;
            this.selectedOption = selectedOption;
            this.outputColor = outputColor;
        }

        int getValue(MachineInterfaceHandler.IMachineInterfaceConnection connection) {
            MachineInterfaceHandler.MachineCheckImplementation<?>[] checks = connection.getAvailableChecks();
            if (this.selectedCheck < checks.length && this.selectedOption < checks[this.selectedCheck].options().length) {
                return checks[this.selectedCheck].options()[this.selectedOption].getValue(checks[this.selectedCheck].instance());
            }
            return 0;
        }

        public CompoundTag writeToNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.putInt("selectedCheck", this.selectedCheck);
            nbt.putInt("selectedOption", this.selectedOption);
            nbt.putInt("outputColor", this.outputColor.getId());
            return nbt;
        }

        static MachineInterfaceConfig<?> readFromNBT(CompoundTag nbt) {
            return new MachineInterfaceConfig(nbt.getInt("selectedCheck"), nbt.getInt("selectedOption"), DyeColor.byId((int)nbt.getInt("outputColor")));
        }

        public int getSelectedCheck() {
            return this.selectedCheck;
        }

        public MachineInterfaceConfig<T> setSelectedCheck(int selectedCheck) {
            this.selectedCheck = selectedCheck;
            return this;
        }

        public int getSelectedOption() {
            return this.selectedOption;
        }

        public MachineInterfaceConfig<T> setSelectedOption(int selectedOption) {
            this.selectedOption = selectedOption;
            return this;
        }

        public DyeColor getOutputColor() {
            return this.outputColor;
        }

        public MachineInterfaceConfig<T> setOutputColor(DyeColor outputColor) {
            this.outputColor = outputColor;
            return this;
        }
    }
}

