/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.multiblocks.BlockMatcher;
import blusunrize.immersiveengineering.api.multiblocks.ClientMultiblocks;
import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import blusunrize.immersiveengineering.api.multiblocks.blocks.MultiblockRegistration;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelper;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityDummy;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.client.utils.BasicClientProperties;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.interfaces.MBMemorizeStructure;
import blusunrize.immersiveengineering.common.util.IELogger;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public abstract class IETemplateMultiblock
extends TemplateMultiblock {
    private final MultiblockRegistration<?> logic;

    public IETemplateMultiblock(ResourceLocation loc, BlockPos masterFromOrigin, BlockPos triggerFromOrigin, BlockPos size, MultiblockRegistration<?> logic) {
        super(loc, masterFromOrigin, triggerFromOrigin, size, (Map<Block, TagKey<Block>>)ImmutableMap.of());
        this.logic = logic;
    }

    public IETemplateMultiblock(ResourceLocation loc, BlockPos masterFromOrigin, BlockPos triggerFromOrigin, BlockPos size, MultiblockRegistration<?> logic, List<BlockMatcher.MatcherPredicate> additionalPredicates) {
        super(loc, masterFromOrigin, triggerFromOrigin, size, additionalPredicates);
        this.logic = logic;
    }

    @Override
    protected void replaceStructureBlock(StructureTemplate.StructureBlockInfo info, Level world, BlockPos actualPos, boolean mirrored, Direction clickDirection, Vec3i offsetFromMaster) {
        BlockState newState = this.logic.block().get().defaultBlockState();
        if ((newState = (BlockState)newState.setValue((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(!offsetFromMaster.equals((Object)Vec3i.ZERO)))).hasProperty((Property)IEProperties.ACTIVE)) {
            newState = (BlockState)newState.setValue((Property)IEProperties.ACTIVE, (Comparable)Boolean.valueOf(false));
        }
        if (newState.hasProperty((Property)IEProperties.MIRRORED)) {
            newState = (BlockState)newState.setValue((Property)IEProperties.MIRRORED, (Comparable)Boolean.valueOf(mirrored));
        }
        if (newState.hasProperty((Property)IEProperties.FACING_HORIZONTAL)) {
            newState = (BlockState)newState.setValue((Property)IEProperties.FACING_HORIZONTAL, (Comparable)clickDirection.getOpposite());
        }
        BlockState oldState = world.getBlockState(actualPos);
        world.setBlock(actualPos, newState, 0);
        BlockEntity curr = world.getBlockEntity(actualPos);
        if (curr instanceof MultiblockBlockEntityDummy) {
            MultiblockBlockEntityDummy dummy = (MultiblockBlockEntityDummy)curr;
            dummy.getHelper().setPositionInMB(info.pos());
        } else if (!(curr instanceof MultiblockBlockEntityMaster)) {
            IELogger.logger.error("Expected MB TE at {} during placement", (Object)actualPos);
        }
        IMultiblockBEHelper helper = ((IMultiblockBE)curr).getHelper();
        IMultiblockLogic iMultiblockLogic = helper.getMultiblock().logic();
        if (iMultiblockLogic instanceof MBMemorizeStructure) {
            MBMemorizeStructure memo = (MBMemorizeStructure)iMultiblockLogic;
            memo.setMemorizedBlockState(helper.getState(), info.pos(), oldState);
        }
        LevelChunk chunk = world.getChunkAt(actualPos);
        world.markAndNotifyBlock(actualPos, chunk, oldState, newState, 3, 512);
    }

    @Override
    public void disassemble(Level world, BlockPos origin, boolean mirrored, Direction clickDirectionAtCreation) {
        IMultiblockLogic iMultiblockLogic;
        IMultiblockBE mb;
        IMultiblockBEHelper helper;
        Object state;
        Mirror mirror = mirrored ? Mirror.FRONT_BACK : Mirror.NONE;
        Rotation rot = DirectionUtils.getRotationBetweenFacings(Direction.NORTH, clickDirectionAtCreation);
        Preconditions.checkNotNull((Object)rot);
        BlockEntity be = world.getBlockEntity(origin);
        Function<BlockPos, BlockState> memorizedState = null;
        if (be instanceof IMultiblockBE && (state = (helper = (mb = (IMultiblockBE)be).getHelper()).getState()) != null && (iMultiblockLogic = helper.getMultiblock().logic()) instanceof MBMemorizeStructure) {
            MBMemorizeStructure memo = (MBMemorizeStructure)iMultiblockLogic;
            memorizedState = pos -> memo.getMemorizedBlockState(state, (BlockPos)pos);
        }
        for (StructureTemplate.StructureBlockInfo info : this.getStructure(world)) {
            BlockPos actualPos = IETemplateMultiblock.withSettingsAndOffset(origin, info.pos(), mirror, rot);
            this.prepareBlockForDisassembly(world, actualPos);
            BlockState blockState = memorizedState != null ? memorizedState.apply(info.pos()) : null;
            world.setBlockAndUpdate(actualPos, this.applyToState(blockState != null ? blockState : info.state(), mirror, rot));
        }
    }

    @Override
    public Vec3i getSize(@Nullable Level world) {
        return this.size;
    }

    @Override
    @Nonnull
    public TemplateMultiblock.TemplateData getTemplate(@Nonnull Level world) {
        TemplateMultiblock.TemplateData result = super.getTemplate(world);
        Vec3i resultSize = result.template().getSize();
        Preconditions.checkState((boolean)resultSize.equals((Object)this.size), (String)"Wrong template size for multiblock %s, template size: %s", (Object)this.getTemplateLocation(), (Object)resultSize);
        return result;
    }

    @Override
    protected void prepareBlockForDisassembly(Level world, BlockPos pos) {
        BlockEntity be = world.getBlockEntity(pos);
        if (be instanceof IMultiblockBE) {
            IMultiblockBE multiblockBE = (IMultiblockBE)be;
            multiblockBE.getHelper().markDisassembling();
        } else if (be != null) {
            IELogger.logger.error("Expected multiblock TE at {}, got {}", (Object)pos, (Object)be);
        }
    }

    @Override
    public void initializeClient(Consumer<ClientMultiblocks.MultiblockManualData> consumer) {
        consumer.accept(new BasicClientProperties(this));
    }

    public ResourceLocation getBlockName() {
        return this.logic.id();
    }

    @Override
    public Component getDisplayName() {
        return this.logic.block().get().getName();
    }

    @Override
    public Block getBlock() {
        return this.logic.block().get();
    }
}

