/*
 * Decompiled with CFR 0.152.
 */
package com.bigenergy.ftbqopt.mixin;

import com.bigenergy.ftbqopt.config.FTBQuestsOptimizerConfig;
import dev.ftb.mods.ftbquests.integration.item_filtering.ItemMatchingSystem;
import dev.ftb.mods.ftbquests.item.MissingItem;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.ItemTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemTask.class}, remap=false)
public abstract class ItemTaskMixin {
    @Shadow
    private ItemStack itemStack;
    @Shadow
    private long count;
    @Shadow
    private ItemMatchingSystem.ComponentMatchType matchComponents;
    @Unique
    private List<ItemStack> ftbqopt$validCache;
    @Unique
    private int ftbqopt$validSig;

    @Unique
    private int ftbqopt$signature() {
        int h = System.identityHashCode(this.itemStack.getItem());
        h = 31 * h + this.itemStack.getComponents().hashCode();
        h = 31 * h + this.matchComponents.ordinal();
        return h;
    }

    @Inject(method={"readData(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;)V"}, at={@At(value="TAIL")})
    private void ftbqopt$invalidateOnRead(CallbackInfo ci) {
        this.ftbqopt$validCache = null;
    }

    @Inject(method={"setStackAndCount(Lnet/minecraft/world/item/ItemStack;I)Ldev/ftb/mods/ftbquests/quest/task/ItemTask;"}, at={@At(value="TAIL")})
    private void ftbqopt$invalidateOnSet(CallbackInfoReturnable<ItemTask> cir) {
        this.ftbqopt$validCache = null;
    }

    @Inject(method={"getValidDisplayItems"}, at={@At(value="HEAD")}, cancellable=true)
    private void ftbqopt$getValidDisplayItemsCached(CallbackInfoReturnable<List<ItemStack>> cir) {
        int sig = this.ftbqopt$signature();
        if (this.ftbqopt$validCache != null && sig == this.ftbqopt$validSig) {
            cir.setReturnValue(this.ftbqopt$validCache);
            return;
        }
        List res = ItemMatchingSystem.INSTANCE.getAllMatchingStacks(this.itemStack);
        this.ftbqopt$validCache = List.copyOf(res);
        this.ftbqopt$validSig = sig;
        cir.setReturnValue(this.ftbqopt$validCache);
    }

    @Inject(method={"submitTask(Ldev/ftb/mods/ftbquests/quest/TeamData;Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void ftbqopt$aggregateSubmit(TeamData teamData, ServerPlayer player, ItemStack craftedItem, CallbackInfo ci) {
        if (!((Boolean)FTBQuestsOptimizerConfig.AGGREGATE_CONSUME.get()).booleanValue()) {
            return;
        }
        ItemTask self = (ItemTask)this;
        if (self.isTaskScreenOnly() || teamData.isCompleted((QuestObject)self) || this.itemStack.getItem() instanceof MissingItem || craftedItem.getItem() instanceof MissingItem || !teamData.canStartTasks(self.getQuest())) {
            return;
        }
        if (!self.consumesResources() || !craftedItem.isEmpty()) {
            return;
        }
        long progress = teamData.getProgress((Task)self);
        long remaining = this.count - progress;
        if (remaining <= 0L) {
            ci.cancel();
            return;
        }
        NonNullList inv = player.getInventory().items;
        boolean changed = false;
        long taken = 0L;
        int limit = Math.max(1, (Integer)FTBQuestsOptimizerConfig.MAX_SLOTS_PER_PASS.get());
        int maxSlots = Math.min(inv.size(), limit);
        for (int i = 0; i < maxSlots && remaining > 0L; ++i) {
            int canTake;
            ItemStack s = (ItemStack)inv.get(i);
            if (s.isEmpty() || !self.test(s) || (canTake = (int)Math.min((long)s.getCount(), remaining)) <= 0) continue;
            s.shrink(canTake);
            if (s.isEmpty()) {
                inv.set(i, (Object)ItemStack.EMPTY);
            }
            changed = true;
            taken += (long)canTake;
            remaining -= (long)canTake;
        }
        if (taken > 0L && teamData.getFile().isServerSide()) {
            teamData.addProgress((Task)self, taken);
            if (changed) {
                player.getInventory().setChanged();
                player.containerMenu.broadcastChanges();
            }
        }
        ci.cancel();
    }
}

