/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.world.item.enchantment;

import fuzs.enchantinginfuser.world.item.enchantment.EnchantingBehavior;
import fuzs.enchantinginfuser.world.level.block.InfuserType;
import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public final class VanillaEnchantingBehavior
implements EnchantingBehavior {
    public static final EnchantingBehavior INSTANCE;
    static EnchantingBehavior enchantingBehavior;

    private VanillaEnchantingBehavior() {
    }

    @Override
    public Collection<String> getScalingNamespaces() {
        return Collections.singleton("minecraft");
    }

    @Override
    public int getEnchantmentPowerLimit(InfuserType infuserType) {
        return infuserType.getConfig().maximumBookshelves;
    }

    @Override
    public float getEnchantmentPower(BlockState blockState, Level level, BlockPos blockPos) {
        return CommonAbstractions.INSTANCE.getEnchantPowerBonus(blockState, level, blockPos);
    }

    @Override
    public float getEnchantmentPowerLimitScale(BlockState blockState, Level level, BlockPos blockPos) {
        return Math.signum(this.getEnchantmentPower(blockState, level, blockPos));
    }

    @Override
    public float getMaximumCostMultiplier() {
        return 1.0f;
    }

    @Override
    public int getMaxLevel(Holder<Enchantment> enchantment) {
        return ((Enchantment)enchantment.value()).getMaxLevel();
    }

    @Override
    public int getMinCost(Holder<Enchantment> enchantment, int level) {
        return ((Enchantment)enchantment.value()).getMinCost(level);
    }

    @Override
    public int getMaxCost(Holder<Enchantment> enchantment, int level) {
        return ((Enchantment)enchantment.value()).getMaxCost(level);
    }

    static {
        enchantingBehavior = INSTANCE = new VanillaEnchantingBehavior();
    }
}

