/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.world.inventory;

import com.mojang.datafixers.util.Pair;
import fuzs.enchantinginfuser.EnchantingInfuser;
import fuzs.enchantinginfuser.config.ModifiableItems;
import fuzs.enchantinginfuser.config.ServerConfig;
import fuzs.enchantinginfuser.network.ClientboundInfuserEnchantmentsMessage;
import fuzs.enchantinginfuser.network.client.ServerboundEnchantmentLevelMessage;
import fuzs.enchantinginfuser.util.EnchantmentCostHelper;
import fuzs.enchantinginfuser.util.EnchantmentPowerHelper;
import fuzs.enchantinginfuser.util.ModEnchantmentHelper;
import fuzs.enchantinginfuser.util.PlayerExperienceHelper;
import fuzs.enchantinginfuser.world.inventory.QuickMoveRuleSet;
import fuzs.enchantinginfuser.world.item.enchantment.EnchantingBehavior;
import fuzs.enchantinginfuser.world.level.block.InfuserBlock;
import fuzs.enchantinginfuser.world.level.block.InfuserType;
import fuzs.puzzleslib.api.container.v1.ContainerMenuHelper;
import fuzs.puzzleslib.api.network.v3.ClientboundMessage;
import fuzs.puzzleslib.api.network.v3.PlayerSet;
import fuzs.puzzleslib.api.network.v3.ServerboundMessage;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntUnaryOperator;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ArmorSlot;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EnchantingTableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class InfuserMenu
extends AbstractContainerMenu
implements ContainerListener {
    public static final int ENCHANT_BUTTON = 0;
    public static final int REPAIR_BUTTON = 1;
    public static final int ENCHANT_ITEM_SLOT = 0;
    public static final int ENCHANTMENT_POWER_DATA_SLOT = 0;
    public static final int ENCHANTING_COST_DATA_SLOT = 1;
    public static final int REPAIR_COST_DATA_SLOT = 2;
    private final InfuserType infuserType;
    private final Container enchantSlots;
    private final ContainerLevelAccess levelAccess;
    private final Player player;
    private final DataSlot enchantmentPower = DataSlot.standalone();
    private final DataSlot enchantingCost = DataSlot.standalone();
    private final DataSlot repairCost = DataSlot.standalone();
    private Object2IntMap<Holder<Enchantment>> enchantmentLevels = Object2IntMaps.emptyMap();
    private Object2IntMap<Holder<Enchantment>> availableEnchantmentLevels = Object2IntMaps.emptyMap();
    private Object2IntMap<Holder<Enchantment>> requiredEnchantmentPowers = Object2IntMaps.emptyMap();
    private int originalEnchantingCost;
    private boolean markedDirty;

    public InfuserMenu(InfuserType infuserType, int containerId, Inventory inventory) {
        this(infuserType, containerId, inventory, (Container)new SimpleContainer(1), ContainerLevelAccess.NULL);
    }

    public InfuserMenu(InfuserType infuserType, int containerId, Inventory inventory, Container container, ContainerLevelAccess levelAccess) {
        super(infuserType.getMenuType(), containerId);
        InfuserMenu.checkContainerSize((Container)container, (int)1);
        this.infuserType = infuserType;
        this.enchantSlots = container;
        this.levelAccess = levelAccess;
        this.player = inventory.player;
        this.addSlot(new Slot(this, container, 0, 8, this.getConfig().allowRepairing.isActive() ? 23 : 34){

            public int getMaxStackSize() {
                return 1;
            }
        });
        for (int k = 0; k < 4; ++k) {
            EquipmentSlot equipmentSlot = InventoryMenu.SLOT_IDS[k];
            ResourceLocation resourceLocation = (ResourceLocation)InventoryMenu.TEXTURE_EMPTY_SLOTS.get(equipmentSlot);
            this.addSlot((Slot)new ArmorSlot((Container)inventory, (LivingEntity)inventory.player, equipmentSlot, 39 - k, 8 + 188 * (k / 2), 103 + k % 2 * 18, resourceLocation));
        }
        ContainerMenuHelper.addInventorySlots((AbstractContainerMenu)this, (Inventory)inventory, (int)30, (int)103);
        this.addSlot(new Slot(this, (Container)inventory, 40, 8, 161){

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_SHIELD);
            }
        });
        this.addDataSlot(this.enchantmentPower);
        this.addDataSlot(this.enchantingCost);
        this.addDataSlot(this.repairCost);
    }

    public ServerConfig.InfuserConfig getConfig() {
        return this.infuserType.getConfig();
    }

    public boolean stillValid(Player player) {
        return this.enchantSlots.stillValid(player);
    }

    public void setItem(int slotId, int stateId, ItemStack stack) {
        super.setItem(slotId, stateId, stack);
        this.broadcastChanges();
    }

    public void setData(int id, int data) {
        super.setData(id, data);
        this.broadcastChanges();
    }

    public void slotsChanged(Container container) {
        if (container == this.enchantSlots) {
            this.levelAccess.execute((level, pos) -> {
                this.enchantmentPower.set(this.getAvailablePower((Level)level, (BlockPos)pos));
                if (this.mayEnchantStack(this.getEnchantableStack())) {
                    this.setInitialEnchantments((Level)level, Optional.of(this.getOriginalEnchantments()));
                    this.enchantingCost.set(this.calculateEnchantingCost());
                    this.repairCost.set(this.calculateRepairCost());
                } else {
                    this.setInitialEnchantments((Level)level, Optional.empty());
                    this.enchantingCost.set(0);
                    this.repairCost.set(0);
                }
            });
        }
        super.slotsChanged(container);
    }

    private boolean mayEnchantStack(ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return false;
        }
        if (this.getConfig().allowBooks) {
            if (itemStack.is(Items.BOOK)) {
                return true;
            }
            if (itemStack.is(Items.ENCHANTED_BOOK)) {
                return this.getConfig().allowModifyingEnchantments != ModifiableItems.UNENCHANTED;
            }
        } else if (ModEnchantmentHelper.isBook(itemStack)) {
            return false;
        }
        return this.getConfig().allowModifyingEnchantments.predicate.test(itemStack);
    }

    private int getAvailablePower(Level level, BlockPos pos) {
        float enchantingPower = 0.0f;
        float maxPowerScale = 1.0f;
        for (BlockPos offset : EnchantingTableBlock.BOOKSHELF_OFFSETS) {
            if (!InfuserBlock.isValidBookShelf(level, pos, offset)) continue;
            BlockState blockState = level.getBlockState(pos.offset((Vec3i)offset));
            enchantingPower += EnchantingBehavior.get().getEnchantmentPower(blockState, level, pos.offset((Vec3i)offset));
            maxPowerScale = Math.max(maxPowerScale, EnchantingBehavior.get().getEnchantmentPowerLimitScale(blockState, level, pos.offset((Vec3i)offset)));
        }
        return (int)Math.min(Math.max(0.0f, enchantingPower), (float)this.getConfig().maximumBookshelves * maxPowerScale);
    }

    public void slotChanged(AbstractContainerMenu containerMenu, int dataSlotIndex, ItemStack itemStack) {
        if (containerMenu == this && dataSlotIndex == 0) {
            this.slotsChanged(this.enchantSlots);
        }
    }

    public void dataChanged(AbstractContainerMenu containerMenu, int dataSlotIndex, int value) {
    }

    public boolean clickClientEnchantmentLevelButton(Holder<Enchantment> enchantment, int enchantmentLevel, ServerboundEnchantmentLevelMessage.Operation operation) {
        int newLevel = this.clickEnchantmentLevelButton(enchantment, operation);
        if (newLevel != enchantmentLevel) {
            EnchantingInfuser.NETWORK.sendMessage((ServerboundMessage)new ServerboundEnchantmentLevelMessage(this.containerId, enchantment, operation));
            return true;
        }
        return false;
    }

    public int clickEnchantmentLevelButton(Holder<Enchantment> enchantment, IntUnaryOperator operation) {
        int enchantmentLevel = this.enchantmentLevels.getInt(enchantment);
        if (enchantmentLevel == 0 && !EnchantmentHelper.isEnchantmentCompatible((Collection)this.getItemEnchantments().keySet(), enchantment)) {
            return 0;
        }
        int newEnchantmentLevel = operation.applyAsInt(enchantmentLevel);
        newEnchantmentLevel = Mth.clamp((int)newEnchantmentLevel, (int)0, (int)EnchantingBehavior.get().getMaxLevel(enchantment));
        if ((newEnchantmentLevel = Math.min(newEnchantmentLevel, this.getAvailableEnchantmentLevel(enchantment))) != enchantmentLevel) {
            this.enchantmentLevels.put(enchantment, newEnchantmentLevel);
            this.markedDirty = !this.getItemEnchantments().equals((Object)this.getOriginalEnchantments());
            this.enchantingCost.set(this.calculateEnchantingCost());
            this.broadcastChanges();
        }
        return newEnchantmentLevel;
    }

    public boolean clickMenuButton(Player player, int id) {
        return switch (id) {
            case 0 -> this.clickEnchantButton(player);
            case 1 -> this.clickRepairButton(player);
            default -> false;
        };
    }

    private boolean clickEnchantButton(Player player) {
        if (this.canEnchant(player)) {
            this.levelAccess.execute((level, pos) -> {
                this.processEnchantingCost(player, (Level)level, (BlockPos)pos, this.getEnchantingCost());
                ItemStack itemStack = ModEnchantmentHelper.setNewEnchantments(this.getEnchantableStack(), this.enchantmentLevels, this.getConfig().increaseAnvilRepairCost);
                this.enchantSlots.setItem(0, itemStack);
                if (this.getEnchantingCost() > 0) {
                    player.awardStat(Stats.ENCHANT_ITEM);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        CriteriaTriggers.ENCHANTED_ITEM.trigger(serverPlayer, itemStack, this.getEnchantingCost());
                    }
                }
                this.enchantSlots.setChanged();
                this.slotsChanged(this.enchantSlots);
                level.playSound(null, pos, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.1f + 0.9f);
            });
            return true;
        }
        return false;
    }

    private void processEnchantingCost(Player player, Level level, BlockPos blockPos, int enchantingCost) {
        if (enchantingCost < 0) {
            int amount = PlayerExperienceHelper.calculateExperienceDelta(this.getItemEnchantments(), this.getOriginalEnchantments(), level.random);
            ExperienceOrb.award((ServerLevel)((ServerLevel)level), (Vec3)Vec3.atCenterOf((Vec3i)blockPos.above()), (int)amount);
        } else if (!player.getAbilities().instabuild) {
            player.giveExperienceLevels(-enchantingCost);
        }
    }

    private int calculateEnchantingCost() {
        int enchantmentCosts = this.getScaledEnchantmentCosts(this.getItemEnchantments()) - this.originalEnchantingCost;
        if (enchantmentCosts == 0 && this.markedDirty) {
            return 1;
        }
        return enchantmentCosts;
    }

    private boolean clickRepairButton(Player player) {
        if (this.canRepair(player)) {
            this.levelAccess.execute((level, pos) -> {
                if (!player.getAbilities().instabuild) {
                    player.giveExperienceLevels(-this.getRepairCost());
                }
                ItemStack itemStack = this.getEnchantableStack();
                int itemRepairCost = (Integer)itemStack.getOrDefault(DataComponents.REPAIR_COST, (Object)0);
                itemStack = itemStack.copy();
                itemStack.setDamageValue(0);
                if (this.getConfig().increaseAnvilRepairCost) {
                    itemStack.set(DataComponents.REPAIR_COST, (Object)AnvilMenu.calculateIncreasedRepairCost((int)itemRepairCost));
                }
                this.enchantSlots.setItem(0, itemStack);
                level.levelEvent(1030, pos, 0);
            });
            return true;
        }
        return false;
    }

    private int calculateRepairCost() {
        ItemStack itemStack = this.getEnchantableStack();
        if (this.getConfig().allowRepairing.canRepair(itemStack)) {
            double repairStep = (double)itemStack.getMaxDamage() * this.getConfig().repair.repairPercentageStep;
            return (int)Math.ceil(Math.ceil((double)itemStack.getDamageValue() / repairStep) * this.getConfig().repair.repairStepMultiplier);
        }
        return 0;
    }

    private int getScaledEnchantmentCosts(ItemEnchantments itemEnchantments) {
        float enchantmentCostsScale;
        if (ModEnchantmentHelper.isBook(this.getEnchantableStack())) {
            enchantmentCostsScale = 1.0f;
        } else {
            int scalingEnchantmentCosts = EnchantmentCostHelper.getScalingEnchantmentCosts((Collection<Holder<Enchantment>>)this.availableEnchantmentLevels.keySet(), this.getScalingNamespaces());
            int maximumCost = Mth.ceil((float)((float)this.getConfig().costs.maximumCost * EnchantingBehavior.get().getMaximumCostMultiplier()));
            enchantmentCostsScale = Math.min(1.0f, (float)maximumCost / (float)scalingEnchantmentCosts);
        }
        float enchantmentCosts = EnchantmentCostHelper.getEnchantmentCosts(itemEnchantments, enchantmentCostsScale);
        int minimumCosts = itemEnchantments.entrySet().stream().mapToInt(Object2IntMap.Entry::getIntValue).sum();
        return Math.max(Mth.ceil((float)enchantmentCosts), minimumCosts);
    }

    private Collection<String> getScalingNamespaces() {
        if (this.getConfig().costs.scaleCostsByVanillaOnly) {
            return EnchantingBehavior.get().getScalingNamespaces();
        }
        return Collections.emptySet();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return QuickMoveRuleSet.of(this, (x$0, x$1, x$2, x$3) -> this.moveItemStackTo(x$0, x$1, x$2, x$3)).addContainerSlotRule(0).addInventoryRules().addInventoryCompartmentRules().quickMoveStack(player, index);
    }

    public int getEnchantmentPower() {
        return Math.min(this.enchantmentPower.get(), this.getEnchantmentPowerLimit());
    }

    public int getEnchantmentPowerLimit() {
        return EnchantingBehavior.get().getEnchantmentPowerLimit(this.infuserType);
    }

    public ItemStack getEnchantableStack() {
        return this.enchantSlots.getItem(0);
    }

    public int getEnchantingCost() {
        return this.enchantingCost.get();
    }

    public int getRepairCost() {
        return this.repairCost.get();
    }

    public boolean canEnchant(Player player) {
        if (!this.getEnchantableStack().isEmpty() && this.markedDirty) {
            return player.experienceLevel >= this.getEnchantingCost() || player.getAbilities().instabuild;
        }
        return false;
    }

    public boolean canRepair(Player player) {
        if (this.getConfig().allowRepairing.canRepair(this.getEnchantableStack())) {
            return player.experienceLevel >= this.getRepairCost() || player.getAbilities().instabuild;
        }
        return false;
    }

    public ItemEnchantments getItemEnchantments() {
        ItemEnchantments.Mutable itemEnchantments = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        for (Object2IntMap.Entry entry : this.enchantmentLevels.object2IntEntrySet()) {
            itemEnchantments.set((Holder)entry.getKey(), entry.getIntValue());
        }
        return itemEnchantments.toImmutable();
    }

    public Set<Holder<Enchantment>> getAllEnchantments() {
        return this.availableEnchantmentLevels.keySet();
    }

    public int getAvailableEnchantmentLevel(Holder<Enchantment> enchantment) {
        return this.availableEnchantmentLevels.getInt(enchantment);
    }

    private ItemEnchantments getOriginalEnchantments() {
        return EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)this.getEnchantableStack());
    }

    private int getRequiredEnchantmentPower(Holder<Enchantment> enchantment) {
        return this.requiredEnchantmentPowers.getInt(enchantment);
    }

    public void setInitialEnchantments(Level level, Optional<ItemEnchantments> itemEnchantments) {
        this.setItemEnchantments(itemEnchantments.orElse(ItemEnchantments.EMPTY));
        if (itemEnchantments.isPresent()) {
            this.initializeEnchantmentMaps(level);
            this.originalEnchantingCost = this.getScaledEnchantmentCosts(itemEnchantments.get());
        } else {
            this.availableEnchantmentLevels = Object2IntMaps.emptyMap();
            this.requiredEnchantmentPowers = Object2IntMaps.emptyMap();
            this.originalEnchantingCost = 0;
        }
        this.sendEnchantments(itemEnchantments);
    }

    private void setItemEnchantments(ItemEnchantments itemEnchantments) {
        Object2IntOpenHashMap enchantmentLevels = new Object2IntOpenHashMap();
        for (Object2IntMap.Entry entry : itemEnchantments.entrySet()) {
            enchantmentLevels.put((Object)((Holder)entry.getKey()), entry.getIntValue());
        }
        this.enchantmentLevels = enchantmentLevels;
        this.markedDirty = false;
    }

    private void initializeEnchantmentMaps(Level level) {
        Collection<Holder<Enchantment>> enchantments = ModEnchantmentHelper.getEnchantmentsForItem(level.registryAccess(), this.getEnchantableStack(), this.infuserType.getAvailableEnchantments(), !this.getConfig().allowAnvilEnchantments);
        int enchantmentValue = this.getEnchantableStack().getItem().getEnchantmentValue();
        this.availableEnchantmentLevels = EnchantmentPowerHelper.getAvailableEnchantmentLevels(this.getEnchantmentPower(), enchantments, this.getEnchantmentPowerLimit(), enchantmentValue);
        if (level.isClientSide) {
            this.requiredEnchantmentPowers = EnchantmentPowerHelper.getRequiredEnchantmentPowers(this.getEnchantmentPower(), enchantments, this.getEnchantmentPowerLimit(), enchantmentValue);
        }
    }

    private void sendEnchantments(Optional<ItemEnchantments> itemEnchantments) {
        this.levelAccess.execute((level, blockPos) -> EnchantingInfuser.NETWORK.sendMessage(PlayerSet.ofEntity((Entity)this.player), (ClientboundMessage)new ClientboundInfuserEnchantmentsMessage(this.containerId, itemEnchantments)));
    }

    public EnchantmentValues getEnchantmentValues(Holder<Enchantment> enchantment) {
        int maxLevel = EnchantingBehavior.get().getMaxLevel(enchantment);
        int availableLevel = this.getAvailableEnchantmentLevel(enchantment);
        int requiredEnchantmentPower = this.getRequiredEnchantmentPower(enchantment);
        return new EnchantmentValues(maxLevel, availableLevel, this.getEnchantmentPower(), requiredEnchantmentPower);
    }

    public record EnchantmentValues(int maxLevel, int availableLevel, int enchantmentPower, int requiredEnchantmentPower) {
    }
}

