/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.util;

import fuzs.enchantinginfuser.world.item.enchantment.EnchantingBehavior;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jetbrains.annotations.Nullable;

public class EnchantmentCostHelper {
    public static float getEnchantmentCosts(ItemEnchantments itemEnchantments, float scale) {
        float enchantmentCosts = 0.0f;
        for (Object2IntMap.Entry entry : itemEnchantments.entrySet()) {
            int enchantmentLevel = entry.getIntValue();
            if (((Holder)entry.getKey()).is(EnchantmentTags.TREASURE)) {
                enchantmentLevel *= 2;
            }
            enchantmentCosts += Math.max((float)enchantmentLevel, (float)EnchantmentCostHelper.getEnchantmentCost((Holder<Enchantment>)((Holder)entry.getKey()), enchantmentLevel) * scale);
        }
        return enchantmentCosts;
    }

    public static int getScalingEnchantmentCosts(Collection<Holder<Enchantment>> itemEnchantments, Collection<String> scalingNamespaces) {
        int scalingEnchantmentCosts = 0;
        for (Holder<Enchantment> enchantment : EnchantmentCostHelper.getMostExpensiveEnchantments(itemEnchantments)) {
            if (!scalingNamespaces.isEmpty() && !scalingNamespaces.contains(((ResourceKey)enchantment.unwrapKey().orElseThrow()).location().getNamespace())) continue;
            scalingEnchantmentCosts += EnchantmentCostHelper.getMaxEnchantmentCost(enchantment);
        }
        return scalingEnchantmentCosts;
    }

    private static Collection<Holder<Enchantment>> getMostExpensiveEnchantments(Collection<Holder<Enchantment>> itemEnchantments) {
        Object2IntOpenHashMap itemEnchantmentCosts = new Object2IntOpenHashMap();
        for (Holder<Enchantment> enchantment : itemEnchantments) {
            int newEnchantmentCost = EnchantmentCostHelper.getMaxEnchantmentCost(enchantment);
            Holder<Enchantment> incompatibleEnchantment = EnchantmentCostHelper.findIncompatibleEnchantment(enchantment, (Collection<Holder<Enchantment>>)itemEnchantmentCosts.keySet());
            if (incompatibleEnchantment != null) {
                int oldEnchantmentCost = itemEnchantmentCosts.removeInt(incompatibleEnchantment);
                if (newEnchantmentCost > oldEnchantmentCost) {
                    itemEnchantmentCosts.put(enchantment, newEnchantmentCost);
                    continue;
                }
                itemEnchantmentCosts.put(incompatibleEnchantment, oldEnchantmentCost);
                continue;
            }
            itemEnchantmentCosts.put(enchantment, newEnchantmentCost);
        }
        return itemEnchantmentCosts.keySet();
    }

    @Nullable
    private static Holder<Enchantment> findIncompatibleEnchantment(Holder<Enchantment> enchantment, Collection<Holder<Enchantment>> enchantments) {
        for (Holder<Enchantment> holder : enchantments) {
            if (Enchantment.areCompatible(enchantment, holder)) continue;
            return holder;
        }
        return null;
    }

    private static int getMaxEnchantmentCost(Holder<Enchantment> enchantment) {
        return EnchantmentCostHelper.getEnchantmentCost(enchantment, EnchantingBehavior.get().getMaxLevel(enchantment));
    }

    private static int getEnchantmentCost(Holder<Enchantment> enchantment, int enchantmentLevel) {
        return ((Enchantment)enchantment.value()).getAnvilCost() * enchantmentLevel;
    }
}

