/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.emiprofessions.emi;

import com.mrbysco.emiprofessions.Constants;
import com.mrbysco.emiprofessions.compat.CompatibilityHelper;
import com.mrbysco.emiprofessions.emi.ProfessionEntry;
import com.mrbysco.emiprofessions.emi.ProfessionRecipe;
import com.mrbysco.emiprofessions.emi.ProfessionWrapper;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

@EmiEntrypoint
public class ProfessionPlugin
implements EmiPlugin {
    private static final ResourceLocation UID = Constants.modLoc("jei_plugin");
    private static final EmiTexture PROFESSION_ICON = new EmiTexture(Constants.modLoc("textures/gui/profession_icon.png"), 0, 0, 16, 16);
    public static final EmiRecipeCategory PROFESSION = new EmiRecipeCategory(Constants.modLoc("professions"), (EmiRenderable)PROFESSION_ICON);

    public void register(EmiRegistry registry) {
        registry.addCategory(PROFESSION);
        registry.addWorkstation(PROFESSION, (EmiIngredient)EmiStack.of((ItemLike)Items.EMERALD));
        registry.addWorkstation(PROFESSION, (EmiIngredient)EmiStack.of((ItemLike)Items.VILLAGER_SPAWN_EGG));
        this.registerRecipes(registry);
    }

    public void registerRecipes(EmiRegistry registration) {
        LinkedList<ProfessionWrapper> entries = new LinkedList<ProfessionWrapper>();
        List professions = BuiltInRegistries.VILLAGER_PROFESSION.stream().toList();
        for (VillagerProfession profession : professions) {
            if (profession == VillagerProfession.NONE) continue;
            LinkedList<ItemStack> stacks = new LinkedList<ItemStack>();
            LinkedList<ResourceLocation> knownItems = new LinkedList<ResourceLocation>();
            List types = BuiltInRegistries.POINT_OF_INTEREST_TYPE.stream().toList();
            for (PoiType poiType : types) {
                Optional poiKey = BuiltInRegistries.POINT_OF_INTEREST_TYPE.getResourceKey((Object)poiType);
                if (!poiKey.isPresent() || !profession.acquirableJobSite().test(BuiltInRegistries.POINT_OF_INTEREST_TYPE.getHolder((ResourceKey)poiKey.get()).orElse(null))) continue;
                for (BlockState state : poiType.matchingStates()) {
                    Block block = (Block)BuiltInRegistries.BLOCK.get(BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()));
                    if (block == null) continue;
                    ItemStack stack = CompatibilityHelper.compatibilityCheck(new ItemStack((ItemLike)block), BuiltInRegistries.VILLAGER_PROFESSION.getKey((Object)profession));
                    ResourceLocation location = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
                    if (stack.isEmpty() || knownItems.contains(location)) continue;
                    stacks.add(stack);
                    knownItems.add(location);
                }
            }
            if (stacks.isEmpty()) continue;
            entries.add(new ProfessionWrapper(new ProfessionEntry(profession, stacks)));
        }
        entries.forEach(entry -> registration.addRecipe(new ProfessionRecipe((ProfessionWrapper)entry)));
    }
}

