/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common;

import com.mojang.brigadier.CommandDispatcher;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiAfterDhInitEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeDhInitEvent;
import com.seibel.distanthorizons.core.api.internal.ClientApi;
import com.seibel.distanthorizons.core.api.internal.SharedApi;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.ConfigHandler;
import com.seibel.distanthorizons.core.config.eventHandlers.presets.ThreadPresetConfigEventHandler;
import com.seibel.distanthorizons.core.dependencyInjection.ModAccessorInjector;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.enums.EMinecraftColor;
import com.seibel.distanthorizons.core.jar.ModJarInfo;
import com.seibel.distanthorizons.core.jar.updater.SelfUpdater;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IModAccessor;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IModChecker;
import com.seibel.distanthorizons.coreapi.DependencyInjection.ApiEventInjector;
import com.seibel.distanthorizons.coreapi.ModInfo;
import java.util.function.Consumer;
import java.util.function.Supplier;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.commands.CommandInitializer;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.DependencySetup;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.minecraft.MinecraftServerWrapper;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;

public abstract class AbstractModInitializer {
    protected static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private CommandInitializer commandInitializer;

    protected abstract void createInitialSharedBindings();

    protected abstract void createInitialClientBindings();

    protected abstract IEventProxy createClientProxy();

    protected abstract IEventProxy createServerProxy(boolean var1);

    protected abstract void initializeModCompat();

    protected abstract void subscribeRegisterCommandsEvent(Consumer<CommandDispatcher<CommandSourceStack>> var1);

    protected abstract void subscribeClientStartedEvent(Runnable var1);

    protected abstract void subscribeServerStartingEvent(Consumer<MinecraftServer> var1);

    protected abstract void runDelayedSetup();

    public void onInitializeClient() {
        DependencySetup.createClientBindings();
        this.createInitialClientBindings();
        LOGGER.info("Initializing Distant Horizons client, firing DhApiBeforeDhInitEvent...", new Object[0]);
        ApiEventInjector.INSTANCE.fireAllEvents(DhApiBeforeDhInitEvent.class, null);
        this.startup();
        this.logBuildInfo();
        this.createClientProxy().registerEvents();
        this.createServerProxy(false).registerEvents();
        this.initializeModCompat();
        this.initConfig();
        AbstractModInitializer.logModIncompatibilityWarnings();
        LOGGER.info("Distant Horizons client Initialized.", new Object[0]);
        this.subscribeClientStartedEvent(this::postInit);
    }

    public void onInitializeServer() {
        DependencySetup.createServerBindings();
        LOGGER.info("Initializing Distant Horizons server, firing DhApiBeforeDhInitEvent event...", new Object[0]);
        ApiEventInjector.INSTANCE.fireAllEvents(DhApiBeforeDhInitEvent.class, null);
        this.startup();
        this.logBuildInfo();
        ThreadPresetConfigEventHandler.INSTANCE.toString();
        this.createServerProxy(true).registerEvents();
        this.initializeModCompat();
        LOGGER.info("Distant Horizons server Initialized, adding event subscribers...", new Object[0]);
        this.commandInitializer = new CommandInitializer();
        this.subscribeRegisterCommandsEvent(dispatcher -> this.commandInitializer.initCommands((CommandDispatcher<CommandSourceStack>)dispatcher));
        this.subscribeServerStartingEvent(server -> {
            MinecraftServerWrapper.INSTANCE.dedicatedServer = (DedicatedServer)server;
            this.initConfig();
            this.postInit();
            this.commandInitializer.onServerReady();
            this.checkForUpdates();
            LOGGER.info("Distant Horizons server Initialized at " + String.valueOf(server.getServerDirectory()), new Object[0]);
        });
    }

    private void startup() {
        DependencySetup.createSharedBindings();
        SharedApi.init();
        this.createInitialSharedBindings();
    }

    private void logBuildInfo() {
        LOGGER.info("Distant Horizons, Version: 2.4.5-b", new Object[0]);
        if (ModInfo.IS_DEV_BUILD) {
            LOGGER.info("DH Branch: " + ModJarInfo.Git_Branch, new Object[0]);
            LOGGER.info("DH Commit: " + ModJarInfo.Git_Commit, new Object[0]);
            LOGGER.info("DH Jar Build Source: " + ModJarInfo.Build_Source, new Object[0]);
        }
    }

    protected <T extends IModAccessor> void tryCreateModCompatAccessor(String modId, Class<? super T> accessorClass, Supplier<T> accessorConstructor) {
        IModChecker modChecker = SingletonInjector.INSTANCE.get(IModChecker.class);
        if (modChecker.isModLoaded(modId)) {
            ModAccessorInjector.INSTANCE.bind(accessorClass, (IModAccessor)accessorConstructor.get());
        } else {
            LOGGER.debug("Skipping mod compatibility accessor for: [" + modId + "]", new Object[0]);
        }
    }

    private void initConfig() {
        ConfigHandler.tryRunFirstTimeSetup();
        Config.completeDelayedSetup();
        DhLogger.runDelayedConfigSetup();
    }

    private void checkForUpdates() {
        if (Config.Client.Advanced.AutoUpdater.enableAutoUpdater.get().booleanValue()) {
            if (Config.Client.Advanced.AutoUpdater.enableSilentUpdates.get().booleanValue()) {
                LOGGER.info("Silent updates are not allowed for dedicated servers; force disabling.", new Object[0]);
                Config.Client.Advanced.AutoUpdater.enableSilentUpdates.set(false);
            }
            SelfUpdater.onStart();
        }
    }

    private void postInit() {
        LOGGER.info("Running Delayed setup...", new Object[0]);
        this.runDelayedSetup();
        if (ConfigHandler.INSTANCE == null) {
            throw new IllegalStateException("Config was not initialized. Make sure to call LodCommonMain.initConfig() before calling this method.");
        }
        LOGGER.info("Delayed setup complete, firing DhApiAfterDhInitEvent event...", new Object[0]);
        ApiEventInjector.INSTANCE.fireAllEvents(DhApiAfterDhInitEvent.class, null);
    }

    private static void logModIncompatibilityWarnings() {
        boolean showChatWarnings = Config.Common.Logging.Warning.showModCompatibilityWarningsOnStartup.get();
        IModChecker modChecker = SingletonInjector.INSTANCE.get(IModChecker.class);
        String startingString = "Partially Incompatible Distant Horizons mod detected: ";
        if (modChecker.isModLoaded("alexscaves")) {
            if (showChatWarnings) {
                String message = String.valueOf((Object)EMinecraftColor.ORANGE) + "Distant Horizons: Alex's Cave detected." + String.valueOf((Object)EMinecraftColor.CLEAR_FORMATTING) + "You may have to change Alex's config for DH to render. ";
                ClientApi.INSTANCE.showChatMessageNextFrame(message);
            }
            LOGGER.warn(startingString + "[Alex's Caves] may require some config changes in order to render Distant Horizons correctly.", new Object[0]);
        }
        if (modChecker.isModLoaded("wwoo")) {
            String wwooWarning = "LODs generated by DH may have grid lines between sections. Disabling either WWOO or DH's distant generator will fix the problem.";
            if (showChatWarnings) {
                String message = String.valueOf((Object)EMinecraftColor.ORANGE) + "Distant Horizons: WWOO detected." + String.valueOf((Object)EMinecraftColor.CLEAR_FORMATTING) + "\n" + wwooWarning;
                ClientApi.INSTANCE.showChatMessageNextFrame(message);
            }
            LOGGER.warn(startingString + "[WWOO] " + wwooWarning, new Object[0]);
        }
        boolean chunkyPresent = false;
        try {
            Class.forName("org.popcraft.chunky.api.ChunkyAPI");
            chunkyPresent = true;
        }
        catch (ClassNotFoundException message) {
            // empty catch block
        }
        if (chunkyPresent) {
            String chunkyWarning = "Chunky can cause DH LODs to have holes since Chunky can generate chunks faster than DH can process them. \nUsing DH's distant generator instead of chunky or increasing DH's CPU thread count can resolve the issue.";
            if (showChatWarnings) {
                String message = String.valueOf((Object)EMinecraftColor.ORANGE) + "Distant Horizons: Chunky detected." + String.valueOf((Object)EMinecraftColor.CLEAR_FORMATTING) + "\n" + chunkyWarning;
                ClientApi.INSTANCE.showChatMessageNextFrame(message);
            }
            LOGGER.warn(startingString + "[Chunky] " + chunkyWarning, new Object[0]);
        }
    }

    public static interface IEventProxy {
        public void registerEvents();
    }
}

