/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts.anim.menu;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.parts.anim.AnimLoaderState;
import com.tom.cpm.shared.parts.anim.ParameterDetails;
import com.tom.cpm.shared.parts.anim.menu.AbstractGestureButtonData;
import com.tom.cpm.shared.parts.anim.menu.BitmaskParameterValueAction;
import com.tom.cpm.shared.parts.anim.menu.GestureButtonType;
import java.io.IOException;

public class BoolParameterToggleButtonData
extends AbstractGestureButtonData.AbstractCommandTriggerableData {
    public int parameter;
    public int mask;
    private BitmaskParameterValueAction action;

    @Override
    protected void parseData(IOHelper block, AnimLoaderState state) throws IOException {
        super.parseData(block, state);
        this.parameter = block.readVarInt();
        this.mask = block.readUnsignedByte();
    }

    @Override
    public void onRegistered() {
        super.onRegistered();
        this.action = new BitmaskParameterValueAction(this.name, this.parameter, this.mask, this.command);
        this.commandActions.add(this.action);
    }

    @Override
    public GestureButtonType getType() {
        return GestureButtonType.BOOL_PARAMETER_TOGGLE;
    }

    @Override
    public void write(IOHelper block) throws IOException {
        super.write(block);
        block.writeVarInt(this.parameter);
        block.write(this.mask);
    }

    public void setInfo(ParameterDetails.ParameterAllocator.BitInfo info) {
        this.parameter = info.param;
        this.mask = info.mask;
    }

    public void toggle() {
        this.action.setValue(-1);
    }

    public boolean getValue() {
        return this.action.getValue() > 0;
    }

    @Override
    public void onKeybind(String arg, boolean press, boolean toggleMode) {
        if (toggleMode) {
            this.action.setValue(-1);
        } else {
            this.action.setValue(press ? 1 : 0);
        }
    }

    @Override
    public String getKeybindId() {
        return "l" + this.name;
    }

    @Override
    public void storeTo(ConfigEntry ce) {
        ce.setFloat(this.name, this.action.getValue());
    }

    @Override
    public void loadFrom(ConfigEntry ce) {
        this.action.setValue(ce.getFloat(this.name, (this.def.getAnimations().getParams().getDefaultParam(this.parameter) & this.mask) == this.mask ? 1.0f : 0.0f) > 0.5f ? 1 : 0);
    }
}

