/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec4f;
import com.tom.cpl.render.RenderTypes;
import com.tom.cpl.render.VBuffers;
import com.tom.cpm.client.CustomPlayerModelsClient;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.client.ModelTexture;
import com.tom.cpm.client.VBufferOut;
import com.tom.cpm.client.optifine.OptifineTexture;
import com.tom.cpm.client.optifine.RedirectModelRendererOF;
import com.tom.cpm.client.vr.VRPlayerRenderer;
import com.tom.cpm.shared.model.PlayerModelParts;
import com.tom.cpm.shared.model.RootModelType;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.model.render.BatchedBuffers;
import com.tom.cpm.shared.model.render.ModelRenderManager;
import com.tom.cpm.shared.model.render.RenderMode;
import com.tom.cpm.shared.model.render.VanillaModelPart;
import com.tom.cpm.shared.skin.TextureProvider;
import java.util.Collections;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class PlayerRenderManager
extends ModelRenderManager<MultiBufferSource, ModelTexture, ModelPart, Model> {
    public static final Function<ResourceLocation, RenderType> armor = RenderType::armorCutoutNoCull;
    public static final Function<ResourceLocation, RenderType> entity = RenderType::entityTranslucent;

    public PlayerRenderManager() {
        this.setFactory(new ModelRenderManager.RedirectHolderFactory<MultiBufferSource, ModelTexture, ModelPart>(){

            @Override
            public <M> ModelRenderManager.RedirectHolder<?, MultiBufferSource, ModelTexture, ModelPart> create(M model, String arg) {
                if ("api".equals(arg) && model instanceof HumanoidModel) {
                    return new RedirectHolderApi(PlayerRenderManager.this, (HumanoidModel<LivingEntity>)((HumanoidModel)model));
                }
                if (CustomPlayerModelsClient.vrLoaded && VRPlayerRenderer.isVRPlayer(model)) {
                    return VRPlayerRenderer.createVRPlayer(PlayerRenderManager.this, model);
                }
                if (model instanceof PlayerModel) {
                    return new RedirectHolderPlayer(PlayerRenderManager.this, (PlayerModel<LivingEntity>)((PlayerModel)model));
                }
                if (model instanceof SkullModel) {
                    return new RedirectHolderSkull(PlayerRenderManager.this, (SkullModel)model);
                }
                if (model instanceof ElytraModel) {
                    return new RedirectHolderElytra(PlayerRenderManager.this, (ElytraModel<LivingEntity>)((ElytraModel)model));
                }
                if (model instanceof HumanoidModel && "armor1".equals(arg)) {
                    return new RedirectHolderArmor1(PlayerRenderManager.this, (HumanoidModel<LivingEntity>)((HumanoidModel)model));
                }
                if (model instanceof HumanoidModel && "armor2".equals(arg)) {
                    return new RedirectHolderArmor2(PlayerRenderManager.this, (HumanoidModel<LivingEntity>)((HumanoidModel)model));
                }
                return null;
            }
        });
        this.setRedirectFactory(new ModelRenderManager.RedirectRendererFactory<Model, ModelTexture, ModelPart>(this){

            @Override
            public ModelRenderManager.RedirectRenderer<ModelPart> create(Model model, ModelRenderManager.RedirectHolder<Model, ?, ModelTexture, ModelPart> access, Supplier<ModelPart> modelPart, VanillaModelPart part) {
                return CustomPlayerModelsClient.optifineLoaded ? new RedirectModelRendererOF((RDH)access, modelPart, part) : new RedirectModelRendererVanilla((RDH)access, modelPart, part);
            }
        });
        this.setVis(m -> m.visible, (m, v) -> {
            m.visible = v;
        });
        this.setModelPosGetters(m -> m.x, m -> m.y, m -> m.z);
        this.setModelRotGetters(m -> m.xRot, m -> m.yRot, m -> m.zRot);
        this.setModelSetters((m, x, y, z) -> {
            m.x = x;
            m.y = y;
            m.z = z;
        }, (m, x, y, z) -> {
            m.xRot = x;
            m.yRot = y;
            m.zRot = z;
        });
        this.setRenderPart(new ModelPart(Collections.emptyList(), Collections.emptyMap()));
    }

    public static void multiplyStacks(MatrixStack.Entry e, PoseStack stack) {
        stack.last().pose().mul((Matrix4fc)new Matrix4f().setTransposed(e.getMatrixArray()));
        stack.last().normal().mul((Matrix3fc)new Matrix3f().set(e.getNormalArray3()).transpose());
    }

    public static class RedirectModelRendererVanilla
    extends RedirectModelRendererBase {
        private PoseStack matrixStackIn;
        private VertexConsumer bufferIn;
        private int packedLightIn;
        private int packedOverlayIn;

        public RedirectModelRendererVanilla(RDH holder, Supplier<ModelPart> parent, VanillaModelPart part) {
            super(holder, parent, part);
        }

        public void render(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
            if (!this.holder.renderTypes.isInitialized()) {
                this.holder.copyModel(this, this.parent);
                this.parent.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
                this.holder.logWarning();
                return;
            }
            this.matrixStackIn = matrixStackIn;
            this.bufferIn = bufferIn;
            this.packedLightIn = packedLightIn;
            this.packedOverlayIn = packedOverlayIn;
            this.color = color;
            this.buffers = this.holder.nextBatch(() -> new VBufferOut(packedLightIn, packedOverlayIn, matrixStackIn), bufferIn);
            this.render();
            this.matrixStackIn = null;
            this.bufferIn = null;
        }

        @Override
        public void renderParent() {
            this.parent.render(this.matrixStackIn, this.bufferIn, this.packedLightIn, this.packedOverlayIn, this.color);
        }
    }

    public static abstract class RedirectModelRendererBase
    extends ModelPart
    implements ModelRenderManager.RedirectRenderer<ModelPart> {
        protected final RDH holder;
        protected final VanillaModelPart part;
        protected final Supplier<ModelPart> parentProvider;
        protected ModelPart parent;
        protected VBuffers buffers;
        protected int color;

        public RedirectModelRendererBase(RDH holder, Supplier<ModelPart> parent, VanillaModelPart part) {
            super(Collections.emptyList(), Collections.emptyMap());
            this.part = part;
            this.holder = holder;
            this.parentProvider = parent;
        }

        @Override
        public VBuffers getVBuffers() {
            return this.buffers;
        }

        @Override
        public ModelPart swapIn() {
            if (this.parent != null) {
                return this;
            }
            this.parent = this.parentProvider.get();
            this.holder.copyModel(this.parent, this);
            this.setInitialPose(this.parent.getInitialPose());
            return this;
        }

        @Override
        public ModelPart swapOut() {
            if (this.parent == null) {
                return this.parentProvider.get();
            }
            ModelPart p = this.parent;
            this.parent = null;
            return p;
        }

        @Override
        public ModelRenderManager.RedirectHolder<?, ?, ?, ModelPart> getHolder() {
            return this.holder;
        }

        @Override
        public ModelPart getParent() {
            return this.parent;
        }

        @Override
        public VanillaModelPart getPart() {
            return this.part;
        }

        @Override
        public Vec4f getColor() {
            return new Vec4f((float)FastColor.ARGB32.red((int)this.color) / 255.0f, (float)FastColor.ARGB32.green((int)this.color) / 255.0f, (float)FastColor.ARGB32.blue((int)this.color) / 255.0f, (float)FastColor.ARGB32.alpha((int)this.color) / 255.0f);
        }

        public void translateAndRotate(PoseStack stack) {
            MatrixStack.Entry e = this.getPartTransform();
            if (e != null) {
                PlayerRenderManager.multiplyStacks(e, stack);
            } else {
                super.translateAndRotate(stack);
            }
        }

        public ModelPart.Cube getRandomCube(RandomSource pRandom) {
            if (this.parent != null) {
                return this.parent.getRandomCube(pRandom);
            }
            return super.getRandomCube(pRandom);
        }
    }

    private static class RedirectHolderArmor2
    extends RDH {
        public RedirectHolderArmor2(PlayerRenderManager mngr, HumanoidModel<LivingEntity> model) {
            super(mngr, (Model)model);
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.body, v -> {
                model.body = v;
            }, RootModelType.ARMOR_LEGGINGS_BODY));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.rightLeg, v -> {
                model.rightLeg = v;
            }, RootModelType.ARMOR_RIGHT_LEG));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.leftLeg, v -> {
                model.leftLeg = v;
            }, RootModelType.ARMOR_LEFT_LEG));
        }
    }

    private static class RedirectHolderArmor1
    extends RDH {
        public RedirectHolderArmor1(PlayerRenderManager mngr, HumanoidModel<LivingEntity> model) {
            super(mngr, (Model)model);
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.head, v -> {
                model.head = v;
            }, RootModelType.ARMOR_HELMET));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.body, v -> {
                model.body = v;
            }, RootModelType.ARMOR_BODY));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.rightArm, v -> {
                model.rightArm = v;
            }, RootModelType.ARMOR_RIGHT_ARM));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.leftArm, v -> {
                model.leftArm = v;
            }, RootModelType.ARMOR_LEFT_ARM));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.rightLeg, v -> {
                model.rightLeg = v;
            }, RootModelType.ARMOR_RIGHT_FOOT));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.leftLeg, v -> {
                model.leftLeg = v;
            }, RootModelType.ARMOR_LEFT_FOOT));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.hat, v -> {
                model.hat = v;
            }, null));
        }
    }

    private static class RedirectHolderElytra
    extends RDH {
        public RedirectHolderElytra(PlayerRenderManager mngr, ElytraModel<LivingEntity> model) {
            super(mngr, (Model)model);
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.rightWing, v -> {
                model.rightWing = v;
            }, RootModelType.ELYTRA_RIGHT));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.leftWing, v -> {
                model.leftWing = v;
            }, RootModelType.ELYTRA_LEFT));
        }
    }

    private static class RedirectHolderSkull
    extends RDH {
        public RedirectHolderSkull(PlayerRenderManager mngr, SkullModel model) {
            super(mngr, (Model)model);
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.head, v -> {
                model.head = v;
            }, PlayerModelParts.HEAD));
        }
    }

    private static class RedirectHolderApi
    extends RDH {
        private ModelRenderManager.RedirectRenderer<ModelPart> head = this.registerHead(new ModelRenderManager.Field<ModelPart>(() -> model.head, v -> {
            model.head = v;
        }, PlayerModelParts.HEAD));

        public RedirectHolderApi(PlayerRenderManager mngr, HumanoidModel<LivingEntity> model) {
            super(mngr, (Model)model);
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.body, v -> {
                model.body = v;
            }, PlayerModelParts.BODY));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.rightArm, v -> {
                model.rightArm = v;
            }, PlayerModelParts.RIGHT_ARM));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.leftArm, v -> {
                model.leftArm = v;
            }, PlayerModelParts.LEFT_ARM));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.rightLeg, v -> {
                model.rightLeg = v;
            }, PlayerModelParts.RIGHT_LEG));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.leftLeg, v -> {
                model.leftLeg = v;
            }, PlayerModelParts.LEFT_LEG));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.hat, v -> {
                model.hat = v;
            }, null)).setCopyFrom(this.head);
            if (model instanceof PlayerModel) {
                PlayerModel mp = (PlayerModel)model;
                this.register(new ModelRenderManager.Field<ModelPart>(() -> mp.leftSleeve, v -> {
                    mp.leftSleeve = v;
                }, null));
                this.register(new ModelRenderManager.Field<ModelPart>(() -> mp.rightSleeve, v -> {
                    mp.rightSleeve = v;
                }, null));
                this.register(new ModelRenderManager.Field<ModelPart>(() -> mp.leftPants, v -> {
                    mp.leftPants = v;
                }, null));
                this.register(new ModelRenderManager.Field<ModelPart>(() -> mp.rightPants, v -> {
                    mp.rightPants = v;
                }, null));
                this.register(new ModelRenderManager.Field<ModelPart>(() -> mp.jacket, v -> {
                    mp.jacket = v;
                }, null));
                this.register(new ModelRenderManager.Field<ModelPart>(() -> mp.cloak, v -> {
                    mp.cloak = v;
                }, RootModelType.CAPE));
            }
        }
    }

    private static class RedirectHolderPlayer
    extends RDH {
        private ModelRenderManager.RedirectRenderer<ModelPart> head = this.registerHead(new ModelRenderManager.Field<ModelPart>(() -> model.head, v -> {
            model.head = v;
        }, PlayerModelParts.HEAD));

        public RedirectHolderPlayer(PlayerRenderManager mngr, PlayerModel<LivingEntity> model) {
            super(mngr, (Model)model);
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.body, v -> {
                model.body = v;
            }, PlayerModelParts.BODY));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.rightArm, v -> {
                model.rightArm = v;
            }, PlayerModelParts.RIGHT_ARM));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.leftArm, v -> {
                model.leftArm = v;
            }, PlayerModelParts.LEFT_ARM));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.rightLeg, v -> {
                model.rightLeg = v;
            }, PlayerModelParts.RIGHT_LEG));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.leftLeg, v -> {
                model.leftLeg = v;
            }, PlayerModelParts.LEFT_LEG));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.hat, v -> {
                model.hat = v;
            }, null)).setCopyFrom(this.head);
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.leftSleeve, v -> {
                model.leftSleeve = v;
            }, null));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.rightSleeve, v -> {
                model.rightSleeve = v;
            }, null));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.leftPants, v -> {
                model.leftPants = v;
            }, null));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.rightPants, v -> {
                model.rightPants = v;
            }, null));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.jacket, v -> {
                model.jacket = v;
            }, null));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.cloak, v -> {
                model.cloak = v;
            }, RootModelType.CAPE));
        }
    }

    public static abstract class RDH
    extends ModelRenderManager.RedirectHolder<Model, MultiBufferSource, ModelTexture, ModelPart> {
        public RDH(ModelRenderManager<MultiBufferSource, ModelTexture, ModelPart, Model> mngr, Model model) {
            super(mngr, model);
            this.batch = new BatchedBuffers<MultiBufferSource, RenderType, VertexConsumer>(this, MultiBufferSource::getBuffer);
        }

        @Override
        public void setupRenderSystem(ModelTexture cbi, TextureSheetType tex) {
            CustomPlayerModelsClient.mc.renderBuilder.build((RenderTypes<RenderMode>)this.renderTypes, (ResourceLocation)cbi);
        }

        @Override
        protected void bindTexture(ModelTexture cbi, TextureProvider skin) {
            skin.bind();
            OptifineTexture.applyOptifineTexture(cbi.getTexture(), skin);
            cbi.setTexture(MinecraftObject.DynTexture.getBoundLoc());
        }

        @Override
        public void swapOut0() {
        }

        @Override
        public void swapIn0() {
        }
    }
}

