/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.helper;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import pro.gravit.utils.command.CommandException;
import pro.gravit.utils.launch.LaunchOptions;

public final class CommonHelper {
    private CommonHelper() {
    }

    public static String low(String s) {
        return s.toLowerCase(Locale.US);
    }

    public static boolean multiMatches(Pattern[] pattern, String from) {
        for (Pattern p : pattern) {
            if (!p.matcher(from).matches()) continue;
            return true;
        }
        return false;
    }

    public static String multiReplace(Pattern[] pattern, String from, String replace) {
        String tmp = null;
        for (Pattern p : pattern) {
            Matcher m = p.matcher(from);
            if (!m.matches()) continue;
            tmp = m.replaceAll(replace);
        }
        return tmp != null ? tmp : from;
    }

    @Deprecated
    public static ScriptEngine newScriptEngine() {
        throw new UnsupportedOperationException("ScriptEngine not supported");
    }

    public static Thread newThread(String name, boolean daemon, Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setDaemon(daemon);
        if (name != null) {
            thread.setName(name);
        }
        return thread;
    }

    public static String replace(String source, String ... params) {
        for (int i = 0; i < params.length; i += 2) {
            source = source.replace("%" + params[i] + "%", params[i + 1]);
        }
        return source;
    }

    public static String replace(Map<String, String> replaceMap, String arg) {
        for (Map.Entry<String, String> e : replaceMap.entrySet()) {
            arg = arg.replace(e.getKey(), e.getValue());
        }
        return arg;
    }

    public static List<String> replace(Map<String, String> replaceMap, List<String> args) {
        ArrayList<String> updatedList = new ArrayList<String>(args.size());
        for (String e : args) {
            updatedList.add(CommonHelper.replace(replaceMap, e));
        }
        return updatedList;
    }

    public static String[] parseCommand(CharSequence line) throws CommandException {
        boolean quoted = false;
        boolean wasQuoted = false;
        LinkedList<String> result = new LinkedList<String>();
        StringBuilder builder = new StringBuilder(100);
        block4: for (int i = 0; i <= line.length(); ++i) {
            char ch;
            boolean end = i >= line.length();
            char c = ch = end ? (char)'\u0000' : line.charAt(i);
            if (end || !quoted && Character.isWhitespace(ch)) {
                if (end && quoted) {
                    throw new CommandException("Quotes wasn't closed");
                }
                if (wasQuoted || !builder.isEmpty()) {
                    result.add(builder.toString());
                }
                wasQuoted = false;
                builder.setLength(0);
                continue;
            }
            switch (ch) {
                case '\"': {
                    quoted = !quoted;
                    wasQuoted = true;
                    continue block4;
                }
                case '\\': {
                    if (i + 1 >= line.length()) {
                        throw new CommandException("Escape character is not specified");
                    }
                    char next = line.charAt(i + 1);
                    builder.append(next);
                    ++i;
                    continue block4;
                }
                default: {
                    builder.append(ch);
                }
            }
        }
        return result.toArray(new String[0]);
    }

    public static GsonBuilder newBuilder() {
        return new GsonBuilder().registerTypeHierarchyAdapter(byte[].class, (Object)ByteArrayToBase64TypeAdapter.INSTANCE);
    }

    public static ArgsParseResult parseJavaArgs(List<String> args) {
        ArrayList<String> classpath = new ArrayList<String>();
        ArrayList<String> jvmArgs = new ArrayList<String>();
        ArrayList<String> runArgs = new ArrayList<String>();
        String jarFile = null;
        String mainClass = null;
        String mainModule = null;
        LaunchOptions.ModuleConf conf = new LaunchOptions.ModuleConf();
        PrevArgType prevArgType = PrevArgType.NONE;
        boolean runArgsBoolean = false;
        boolean first = false;
        block35: for (String arg : args) {
            if (runArgsBoolean) {
                runArgs.add(arg);
                continue;
            }
            if (!first) {
                if (!arg.startsWith("-")) continue;
                first = true;
            }
            switch (prevArgType.ordinal()) {
                case 0: {
                    break;
                }
                case 1: {
                    char c = ':';
                    int i = arg.indexOf(c);
                    if (i < 0) {
                        c = ';';
                    }
                    String[] l = arg.split(Character.toString(c));
                    conf.modulePath.addAll(Arrays.asList(l));
                    prevArgType = PrevArgType.NONE;
                    continue block35;
                }
                case 6: {
                    char c = ':';
                    int i = arg.indexOf(c);
                    if (i < 0) {
                        c = ';';
                    }
                    String[] l = arg.split(Character.toString(c));
                    classpath.addAll(Arrays.asList(l));
                    prevArgType = PrevArgType.POST_CLASSPATH;
                    continue block35;
                }
                case 2: {
                    String[] l = arg.split(",");
                    conf.modules.addAll(Arrays.asList(l));
                    prevArgType = PrevArgType.NONE;
                    continue block35;
                }
                case 3: {
                    String[] l = arg.split("=");
                    conf.opens.put(l[0], l[1]);
                    prevArgType = PrevArgType.NONE;
                    continue block35;
                }
                case 4: {
                    String[] l = arg.split("=");
                    conf.exports.put(l[0], l[1]);
                    prevArgType = PrevArgType.NONE;
                    continue block35;
                }
                case 5: {
                    String[] l = arg.split("=");
                    if (l.length != 2) continue block35;
                    conf.reads.put(l[0], l[1]);
                    prevArgType = PrevArgType.NONE;
                    continue block35;
                }
                case 10: {
                    String[] l = arg.split("/");
                    mainModule = l[0];
                    mainClass = l[1];
                    runArgsBoolean = true;
                    prevArgType = PrevArgType.NONE;
                    continue block35;
                }
                case 7: {
                    mainClass = arg;
                    runArgsBoolean = true;
                    prevArgType = PrevArgType.NONE;
                    continue block35;
                }
                case 8: {
                    jarFile = arg;
                    runArgsBoolean = true;
                    prevArgType = PrevArgType.NONE;
                    continue block35;
                }
            }
            switch (arg) {
                case "--module-path": 
                case "-p": {
                    prevArgType = PrevArgType.MODULE_PATH;
                    continue block35;
                }
                case "--classpath": 
                case "-cp": {
                    prevArgType = PrevArgType.CLASSPATH;
                    continue block35;
                }
                case "--add-modules": {
                    prevArgType = PrevArgType.ADD_MODULES;
                    continue block35;
                }
                case "--add-opens": {
                    prevArgType = PrevArgType.ADD_OPENS;
                    continue block35;
                }
                case "--add-exports": {
                    prevArgType = PrevArgType.ADD_EXPORTS;
                    continue block35;
                }
                case "--add-reads": {
                    prevArgType = PrevArgType.ADD_READS;
                    continue block35;
                }
                case "--module": 
                case "-m": {
                    prevArgType = PrevArgType.MODULE;
                    continue block35;
                }
                case "-jar": {
                    prevArgType = PrevArgType.JAR;
                    continue block35;
                }
            }
            jvmArgs.add(arg);
        }
        return new ArgsParseResult(conf, classpath, jvmArgs, mainClass, mainModule, jarFile, args);
    }

    public static <K, V> V multimapFirstOrNullValue(K key, Map<K, List<V>> params) {
        List list = params.getOrDefault(key, Collections.emptyList());
        if (list.isEmpty()) {
            return null;
        }
        return (V)list.getFirst();
    }

    private static class ByteArrayToBase64TypeAdapter
    implements JsonSerializer<byte[]>,
    JsonDeserializer<byte[]> {
        private static final ByteArrayToBase64TypeAdapter INSTANCE = new ByteArrayToBase64TypeAdapter();
        private final Base64.Decoder decoder = Base64.getUrlDecoder();
        private final Base64.Encoder encoder = Base64.getUrlEncoder();

        private ByteArrayToBase64TypeAdapter() {
        }

        public byte[] deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonArray()) {
                JsonArray byteArr = json.getAsJsonArray();
                byte[] arr = new byte[byteArr.size()];
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = byteArr.get(i).getAsByte();
                }
                return arr;
            }
            return this.decoder.decode(json.getAsString());
        }

        public JsonElement serialize(byte[] src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(this.encoder.encodeToString(src));
        }
    }

    private static enum PrevArgType {
        NONE,
        MODULE_PATH,
        ADD_MODULES,
        ADD_OPENS,
        ADD_EXPORTS,
        ADD_READS,
        CLASSPATH,
        POST_CLASSPATH,
        JAR,
        MAINCLASS,
        MODULE;

    }

    public record ArgsParseResult(LaunchOptions.ModuleConf conf, List<String> classpath, List<String> jvmArgs, String mainClass, String mainModule, String jarFile, List<String> args) {
    }
}

