/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common;

import com.google.common.collect.BiMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.registries.datamaps.DataMapsUpdatedEvent;
import net.neoforged.neoforge.registries.datamaps.builtin.NeoForgeDataMaps;
import net.neoforged.neoforge.registries.datamaps.builtin.Oxidizable;
import net.neoforged.neoforge.registries.datamaps.builtin.Waxable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class DataMapHooks {
    @ApiStatus.Internal
    public static boolean didHaveToFallbackToVanillaMaps = false;
    private static final Map<Block, Block> INVERSE_OXIDIZABLES_DATAMAP_INTERNAL = new HashMap<Block, Block>();
    private static final Map<Block, Block> INVERSE_WAXABLES_DATAMAP_INTERNAL = new HashMap<Block, Block>();
    public static final Map<Block, Block> INVERSE_OXIDIZABLES_DATAMAP = Collections.unmodifiableMap(INVERSE_OXIDIZABLES_DATAMAP_INTERNAL);
    public static final Map<Block, Block> INVERSE_WAXABLES_DATAMAP = Collections.unmodifiableMap(INVERSE_WAXABLES_DATAMAP_INTERNAL);

    @Nullable
    public static Block getNextOxidizedStage(Block block) {
        Oxidizable oxidizable = (Oxidizable)block.builtInRegistryHolder().getData(NeoForgeDataMaps.OXIDIZABLES);
        return oxidizable != null ? oxidizable.nextOxidationStage() : (Block)((BiMap)WeatheringCopper.NEXT_BY_BLOCK.get()).get((Object)block);
    }

    @Nullable
    public static Block getPreviousOxidizedStage(Block block) {
        return INVERSE_OXIDIZABLES_DATAMAP.containsKey(block) ? INVERSE_OXIDIZABLES_DATAMAP.get(block) : (Block)((BiMap)WeatheringCopper.PREVIOUS_BY_BLOCK.get()).get((Object)block);
    }

    @Nullable
    public static Block getBlockWaxed(Block block) {
        Waxable waxable = (Waxable)block.builtInRegistryHolder().getData(NeoForgeDataMaps.WAXABLES);
        return waxable != null ? waxable.waxed() : (Block)((BiMap)HoneycombItem.WAXABLES.get()).get((Object)block);
    }

    @Nullable
    public static Block getBlockUnwaxed(Block block) {
        return INVERSE_WAXABLES_DATAMAP.containsKey(block) ? INVERSE_WAXABLES_DATAMAP.get(block) : (Block)((BiMap)HoneycombItem.WAX_OFF_BY_BLOCK.get()).get((Object)block);
    }

    @SubscribeEvent
    static void onDataMapsUpdated(DataMapsUpdatedEvent event) {
        event.ifRegistry(Registries.BLOCK, registry -> {
            INVERSE_OXIDIZABLES_DATAMAP_INTERNAL.clear();
            INVERSE_WAXABLES_DATAMAP_INTERNAL.clear();
            registry.getDataMap(NeoForgeDataMaps.OXIDIZABLES).forEach((resourceKey, oxidizable) -> {
                Block block = (Block)BuiltInRegistries.BLOCK.get(resourceKey);
                INVERSE_OXIDIZABLES_DATAMAP_INTERNAL.put(oxidizable.nextOxidationStage(), block);
                for (BlockState state : block.getStateDefinition().getPossibleStates()) {
                    state.initCache();
                }
            });
            ((BiMap)WeatheringCopper.PREVIOUS_BY_BLOCK.get()).forEach((after, before) -> {
                if (!INVERSE_OXIDIZABLES_DATAMAP_INTERNAL.containsKey(after)) {
                    INVERSE_OXIDIZABLES_DATAMAP_INTERNAL.put((Block)after, (Block)before);
                    didHaveToFallbackToVanillaMaps = true;
                }
            });
            registry.getDataMap(NeoForgeDataMaps.WAXABLES).forEach((resourceKey, waxable) -> INVERSE_WAXABLES_DATAMAP_INTERNAL.put(waxable.waxed(), (Block)BuiltInRegistries.BLOCK.get(resourceKey)));
            ((BiMap)HoneycombItem.WAX_OFF_BY_BLOCK.get()).forEach((after, before) -> {
                if (!INVERSE_WAXABLES_DATAMAP_INTERNAL.containsKey(after)) {
                    INVERSE_OXIDIZABLES_DATAMAP_INTERNAL.put((Block)after, (Block)before);
                    didHaveToFallbackToVanillaMaps = true;
                }
            });
        });
    }
}

