/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.util.GsonHelper;
import org.slf4j.Logger;

public abstract class AbstractPackResources
implements PackResources {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PackLocationInfo location;

    protected AbstractPackResources(PackLocationInfo p_326071_) {
        this.location = p_326071_;
    }

    @Override
    @Nullable
    public <T> T getMetadataSection(MetadataSectionSerializer<T> p_10213_) throws IOException {
        T object;
        IoSupplier<InputStream> iosupplier = this.getRootResource("pack.mcmeta");
        if (iosupplier == null) {
            return null;
        }
        try (InputStream inputstream = (InputStream)iosupplier.get();){
            object = AbstractPackResources.getMetadataFromStream(p_10213_, inputstream);
        }
        return object;
    }

    @Nullable
    public static <T> T getMetadataFromStream(MetadataSectionSerializer<T> p_10215_, InputStream p_10216_) {
        JsonObject jsonobject;
        try (BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(p_10216_, StandardCharsets.UTF_8));){
            jsonobject = GsonHelper.parse((Reader)bufferedreader);
        }
        catch (Exception exception1) {
            LOGGER.error("Couldn't load {} metadata", (Object)p_10215_.getMetadataSectionName(), (Object)exception1);
            return null;
        }
        if (!jsonobject.has(p_10215_.getMetadataSectionName())) {
            return null;
        }
        try {
            return (T)p_10215_.fromJson(GsonHelper.getAsJsonObject((JsonObject)jsonobject, (String)p_10215_.getMetadataSectionName()));
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't load {} metadata", (Object)p_10215_.getMetadataSectionName(), (Object)exception);
            return null;
        }
    }

    @Override
    public PackLocationInfo location() {
        return this.location;
    }

    public String toString() {
        return String.format(Locale.ROOT, "%s: %s", this.getClass().getName(), this.location.id());
    }
}

