/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.advancements.TreeNodePosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.slf4j.Logger;

public class ServerAdvancementManager
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().create();
    private Map<ResourceLocation, AdvancementHolder> advancements = Map.of();
    private AdvancementTree tree = new AdvancementTree();
    private final HolderLookup.Provider registries;

    public ServerAdvancementManager(HolderLookup.Provider p_323943_) {
        super(GSON, Registries.elementsDirPath(Registries.ADVANCEMENT));
        this.registries = p_323943_;
    }

    @Override
    protected void apply(Map<ResourceLocation, JsonElement> p_136034_, ResourceManager p_136035_, ProfilerFiller p_136036_) {
        ConditionalOps registryops = this.makeConditionalOps();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        p_136034_.forEach((arg_0, arg_1) -> this.lambda$apply$0((RegistryOps)registryops, builder, arg_0, arg_1));
        this.advancements = builder.buildOrThrow();
        AdvancementTree advancementtree = new AdvancementTree();
        advancementtree.addAll(this.advancements.values());
        for (AdvancementNode advancementnode : advancementtree.roots()) {
            if (!advancementnode.holder().value().display().isPresent()) continue;
            TreeNodePosition.run((AdvancementNode)advancementnode);
        }
        this.tree = advancementtree;
    }

    private void validate(ResourceLocation p_312696_, Advancement p_312110_) {
        ProblemReporter.Collector problemreporter$collector = new ProblemReporter.Collector();
        p_312110_.validate((ProblemReporter)problemreporter$collector, this.registries.asGetterLookup());
        problemreporter$collector.getReport().ifPresent(p_344260_ -> LOGGER.warn("Found validation problems in advancement {}: \n{}", (Object)p_312696_, p_344260_));
    }

    @Nullable
    public AdvancementHolder get(ResourceLocation p_301079_) {
        return this.advancements.get(p_301079_);
    }

    public AdvancementTree tree() {
        return this.tree;
    }

    public Collection<AdvancementHolder> getAllAdvancements() {
        return this.advancements.values();
    }

    private /* synthetic */ void lambda$apply$0(RegistryOps registryops, ImmutableMap.Builder builder, ResourceLocation p_337529_, JsonElement p_337530_) {
        try {
            Advancement advancement = ICondition.getWithWithConditionsCodec(Advancement.CONDITIONAL_CODEC, (DynamicOps)registryops, (Object)p_337530_).orElse(null);
            if (advancement == null) {
                LOGGER.debug("Skipping loading advancement {} as its conditions were not met", (Object)p_337529_);
                return;
            }
            this.validate(p_337529_, advancement);
            builder.put((Object)p_337529_, (Object)new AdvancementHolder(p_337529_, advancement));
        }
        catch (Exception exception) {
            LOGGER.error("Parsing error loading custom advancement {}: {}", (Object)p_337529_, (Object)exception.getMessage());
        }
    }
}

