/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.shaders.AbstractUniform;
import com.mojang.blaze3d.shaders.BlendMode;
import com.mojang.blaze3d.shaders.Effect;
import com.mojang.blaze3d.shaders.EffectProgram;
import com.mojang.blaze3d.shaders.Program;
import com.mojang.blaze3d.shaders.ProgramManager;
import com.mojang.blaze3d.shaders.Shader;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ChainedJsonException;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.GsonHelper;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class EffectInstance
implements Effect,
AutoCloseable {
    private static final String EFFECT_SHADER_PATH = "shaders/program/";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final AbstractUniform DUMMY_UNIFORM = new AbstractUniform();
    private static final boolean ALWAYS_REAPPLY = true;
    private static EffectInstance lastAppliedEffect;
    private static int lastProgramId;
    private final Map<String, IntSupplier> samplerMap = Maps.newHashMap();
    private final List<String> samplerNames = Lists.newArrayList();
    private final List<Integer> samplerLocations = Lists.newArrayList();
    private final List<Uniform> uniforms = Lists.newArrayList();
    private final List<Integer> uniformLocations = Lists.newArrayList();
    private final Map<String, Uniform> uniformMap = Maps.newHashMap();
    private final int programId;
    private final String name;
    private boolean dirty;
    private final BlendMode blend;
    private final List<Integer> attributes;
    private final List<String> attributeNames;
    private final EffectProgram vertexProgram;
    private final EffectProgram fragmentProgram;

    public EffectInstance(ResourceProvider p_331011_, String p_108942_) throws IOException {
        ResourceLocation rl = ResourceLocation.tryParse(p_108942_);
        ResourceLocation resourcelocation = ResourceLocation.fromNamespaceAndPath(rl.getNamespace(), EFFECT_SHADER_PATH + rl.getPath() + ".json");
        this.name = p_108942_;
        Resource resource = p_331011_.getResourceOrThrow(resourcelocation);
        try (BufferedReader reader = resource.openAsReader();){
            JsonArray jsonarray2;
            JsonArray jsonarray1;
            JsonObject jsonobject = GsonHelper.parse((Reader)reader);
            String s = GsonHelper.getAsString((JsonObject)jsonobject, (String)"vertex");
            String s1 = GsonHelper.getAsString((JsonObject)jsonobject, (String)"fragment");
            JsonArray jsonarray = GsonHelper.getAsJsonArray((JsonObject)jsonobject, (String)"samplers", null);
            if (jsonarray != null) {
                int i = 0;
                for (Object jsonelement : jsonarray) {
                    try {
                        this.parseSamplerNode((JsonElement)jsonelement);
                    }
                    catch (Exception exception2) {
                        ChainedJsonException chainedjsonexception1 = ChainedJsonException.forException((Exception)exception2);
                        chainedjsonexception1.prependJsonKey("samplers[" + i + "]");
                        throw chainedjsonexception1;
                    }
                    ++i;
                }
            }
            if ((jsonarray1 = GsonHelper.getAsJsonArray((JsonObject)jsonobject, (String)"attributes", null)) != null) {
                int j = 0;
                this.attributes = Lists.newArrayListWithCapacity((int)jsonarray1.size());
                this.attributeNames = Lists.newArrayListWithCapacity((int)jsonarray1.size());
                for (Iterator jsonelement1 : jsonarray1) {
                    try {
                        this.attributeNames.add(GsonHelper.convertToString((JsonElement)jsonelement1, (String)"attribute"));
                    }
                    catch (Exception exception1) {
                        ChainedJsonException chainedjsonexception2 = ChainedJsonException.forException((Exception)exception1);
                        chainedjsonexception2.prependJsonKey("attributes[" + j + "]");
                        throw chainedjsonexception2;
                    }
                    ++j;
                }
            } else {
                this.attributes = null;
                this.attributeNames = null;
            }
            if ((jsonarray2 = GsonHelper.getAsJsonArray((JsonObject)jsonobject, (String)"uniforms", null)) != null) {
                int k = 0;
                for (JsonElement jsonelement2 : jsonarray2) {
                    try {
                        this.parseUniformNode(jsonelement2);
                    }
                    catch (Exception exception) {
                        ChainedJsonException chainedjsonexception3 = ChainedJsonException.forException((Exception)exception);
                        chainedjsonexception3.prependJsonKey("uniforms[" + k + "]");
                        throw chainedjsonexception3;
                    }
                    ++k;
                }
            }
            this.blend = EffectInstance.parseBlendNode(GsonHelper.getAsJsonObject((JsonObject)jsonobject, (String)"blend", null));
            this.vertexProgram = EffectInstance.getOrCreate(p_331011_, Program.Type.VERTEX, s);
            this.fragmentProgram = EffectInstance.getOrCreate(p_331011_, Program.Type.FRAGMENT, s1);
            this.programId = ProgramManager.createProgram();
            ProgramManager.linkShader((Shader)this);
            this.updateLocations();
            if (this.attributeNames != null) {
                for (String s2 : this.attributeNames) {
                    int l = Uniform.glGetAttribLocation((int)this.programId, (CharSequence)s2);
                    this.attributes.add(l);
                }
            }
        }
        catch (Exception exception3) {
            ChainedJsonException chainedjsonexception = ChainedJsonException.forException((Exception)exception3);
            chainedjsonexception.setFilenameAndFlush(resourcelocation.getPath() + " (" + resource.sourcePackId() + ")");
            throw chainedjsonexception;
        }
        this.markDirty();
    }

    public static EffectProgram getOrCreate(ResourceProvider p_330579_, Program.Type p_172568_, String p_172569_) throws IOException {
        EffectProgram effectprogram;
        Program program = (Program)p_172568_.getPrograms().get(p_172569_);
        if (program != null && !(program instanceof EffectProgram)) {
            throw new InvalidClassException("Program is not of type EffectProgram");
        }
        if (program == null) {
            ResourceLocation rl = ResourceLocation.tryParse(p_172569_);
            ResourceLocation resourcelocation = ResourceLocation.fromNamespaceAndPath(rl.getNamespace(), EFFECT_SHADER_PATH + rl.getPath() + p_172568_.getExtension());
            Resource resource = p_330579_.getResourceOrThrow(resourcelocation);
            try (InputStream inputstream = resource.open();){
                effectprogram = EffectProgram.compileShader((Program.Type)p_172568_, (String)p_172569_, (InputStream)inputstream, (String)resource.sourcePackId());
            }
        } else {
            effectprogram = (EffectProgram)program;
        }
        return effectprogram;
    }

    public static BlendMode parseBlendNode(@Nullable JsonObject p_108951_) {
        if (p_108951_ == null) {
            return new BlendMode();
        }
        int i = 32774;
        int j = 1;
        int k = 0;
        int l = 1;
        int i1 = 0;
        boolean flag = true;
        boolean flag1 = false;
        if (GsonHelper.isStringValue((JsonObject)p_108951_, (String)"func") && (i = BlendMode.stringToBlendFunc((String)p_108951_.get("func").getAsString())) != 32774) {
            flag = false;
        }
        if (GsonHelper.isStringValue((JsonObject)p_108951_, (String)"srcrgb") && (j = BlendMode.stringToBlendFactor((String)p_108951_.get("srcrgb").getAsString())) != 1) {
            flag = false;
        }
        if (GsonHelper.isStringValue((JsonObject)p_108951_, (String)"dstrgb") && (k = BlendMode.stringToBlendFactor((String)p_108951_.get("dstrgb").getAsString())) != 0) {
            flag = false;
        }
        if (GsonHelper.isStringValue((JsonObject)p_108951_, (String)"srcalpha")) {
            l = BlendMode.stringToBlendFactor((String)p_108951_.get("srcalpha").getAsString());
            if (l != 1) {
                flag = false;
            }
            flag1 = true;
        }
        if (GsonHelper.isStringValue((JsonObject)p_108951_, (String)"dstalpha")) {
            i1 = BlendMode.stringToBlendFactor((String)p_108951_.get("dstalpha").getAsString());
            if (i1 != 0) {
                flag = false;
            }
            flag1 = true;
        }
        if (flag) {
            return new BlendMode();
        }
        return flag1 ? new BlendMode(j, k, l, i1, i) : new BlendMode(j, k, i);
    }

    @Override
    public void close() {
        for (Uniform uniform : this.uniforms) {
            uniform.close();
        }
        ProgramManager.releaseProgram((Shader)this);
    }

    public void clear() {
        RenderSystem.assertOnRenderThread();
        ProgramManager.glUseProgram((int)0);
        lastProgramId = -1;
        lastAppliedEffect = null;
        for (int i = 0; i < this.samplerLocations.size(); ++i) {
            if (this.samplerMap.get(this.samplerNames.get(i)) == null) continue;
            GlStateManager._activeTexture(33984 + i);
            GlStateManager._bindTexture(0);
        }
    }

    public void apply() {
        this.dirty = false;
        lastAppliedEffect = this;
        this.blend.apply();
        if (this.programId != lastProgramId) {
            ProgramManager.glUseProgram((int)this.programId);
            lastProgramId = this.programId;
        }
        for (int i = 0; i < this.samplerLocations.size(); ++i) {
            String s = this.samplerNames.get(i);
            IntSupplier intsupplier = this.samplerMap.get(s);
            if (intsupplier == null) continue;
            RenderSystem.activeTexture(33984 + i);
            int j = intsupplier.getAsInt();
            if (j == -1) continue;
            RenderSystem.bindTexture(j);
            Uniform.uploadInteger((int)this.samplerLocations.get(i), (int)i);
        }
        for (Uniform uniform : this.uniforms) {
            uniform.upload();
        }
    }

    public void markDirty() {
        this.dirty = true;
    }

    @Nullable
    public Uniform getUniform(String p_108953_) {
        RenderSystem.assertOnRenderThread();
        return this.uniformMap.get(p_108953_);
    }

    public AbstractUniform safeGetUniform(String p_108961_) {
        Uniform uniform = this.getUniform(p_108961_);
        return uniform == null ? DUMMY_UNIFORM : uniform;
    }

    private void updateLocations() {
        RenderSystem.assertOnRenderThread();
        IntArrayList intlist = new IntArrayList();
        for (int i = 0; i < this.samplerNames.size(); ++i) {
            String s = this.samplerNames.get(i);
            int j = Uniform.glGetUniformLocation((int)this.programId, (CharSequence)s);
            if (j == -1) {
                LOGGER.warn("Shader {} could not find sampler named {} in the specified shader program.", (Object)this.name, (Object)s);
                this.samplerMap.remove(s);
                intlist.add(i);
                continue;
            }
            this.samplerLocations.add(j);
        }
        for (int l = intlist.size() - 1; l >= 0; --l) {
            this.samplerNames.remove(intlist.getInt(l));
        }
        for (Uniform uniform : this.uniforms) {
            String s1 = uniform.getName();
            int k = Uniform.glGetUniformLocation((int)this.programId, (CharSequence)s1);
            if (k == -1) {
                LOGGER.warn("Shader {} could not find uniform named {} in the specified shader program.", (Object)this.name, (Object)s1);
                continue;
            }
            this.uniformLocations.add(k);
            uniform.setLocation(k);
            this.uniformMap.put(s1, uniform);
        }
    }

    private void parseSamplerNode(JsonElement p_108949_) {
        JsonObject jsonobject = GsonHelper.convertToJsonObject((JsonElement)p_108949_, (String)"sampler");
        String s = GsonHelper.getAsString((JsonObject)jsonobject, (String)"name");
        if (!GsonHelper.isStringValue((JsonObject)jsonobject, (String)"file")) {
            this.samplerMap.put(s, null);
            this.samplerNames.add(s);
        } else {
            this.samplerNames.add(s);
        }
    }

    public void setSampler(String p_108955_, IntSupplier p_108956_) {
        if (this.samplerMap.containsKey(p_108955_)) {
            this.samplerMap.remove(p_108955_);
        }
        this.samplerMap.put(p_108955_, p_108956_);
        this.markDirty();
    }

    private void parseUniformNode(JsonElement p_108959_) throws ChainedJsonException {
        JsonObject jsonobject = GsonHelper.convertToJsonObject((JsonElement)p_108959_, (String)"uniform");
        String s = GsonHelper.getAsString((JsonObject)jsonobject, (String)"name");
        int i = Uniform.getTypeFromString((String)GsonHelper.getAsString((JsonObject)jsonobject, (String)"type"));
        int j = GsonHelper.getAsInt((JsonObject)jsonobject, (String)"count");
        float[] afloat = new float[Math.max(j, 16)];
        JsonArray jsonarray = GsonHelper.getAsJsonArray((JsonObject)jsonobject, (String)"values");
        if (jsonarray.size() != j && jsonarray.size() > 1) {
            throw new ChainedJsonException("Invalid amount of values specified (expected " + j + ", found " + jsonarray.size() + ")");
        }
        int k = 0;
        for (JsonElement jsonelement : jsonarray) {
            try {
                afloat[k] = GsonHelper.convertToFloat((JsonElement)jsonelement, (String)"value");
            }
            catch (Exception exception) {
                ChainedJsonException chainedjsonexception = ChainedJsonException.forException((Exception)exception);
                chainedjsonexception.prependJsonKey("values[" + k + "]");
                throw chainedjsonexception;
            }
            ++k;
        }
        if (j > 1 && jsonarray.size() == 1) {
            while (k < j) {
                afloat[k] = afloat[0];
                ++k;
            }
        }
        int l = j > 1 && j <= 4 && i < 8 ? j - 1 : 0;
        Uniform uniform = new Uniform(s, i + l, j, (Shader)this);
        if (i <= 3) {
            uniform.setSafe((int)afloat[0], (int)afloat[1], (int)afloat[2], (int)afloat[3]);
        } else if (i <= 7) {
            uniform.setSafe(afloat[0], afloat[1], afloat[2], afloat[3]);
        } else {
            uniform.set(afloat);
        }
        this.uniforms.add(uniform);
    }

    public Program getVertexProgram() {
        return this.vertexProgram;
    }

    public Program getFragmentProgram() {
        return this.fragmentProgram;
    }

    public void attachToProgram() {
        this.fragmentProgram.attachToEffect((Effect)this);
        this.vertexProgram.attachToEffect((Effect)this);
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.programId;
    }

    static {
        lastProgramId = -1;
    }
}

