/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;

public abstract class DimensionSpecialEffects {
    private static final Object2ObjectMap<ResourceLocation, DimensionSpecialEffects> EFFECTS = (Object2ObjectMap)Util.make(new Object2ObjectArrayMap(), p_108881_ -> {
        OverworldEffects $$1 = new OverworldEffects();
        p_108881_.defaultReturnValue((Object)$$1);
        p_108881_.put((Object)BuiltinDimensionTypes.OVERWORLD_EFFECTS, (Object)$$1);
        p_108881_.put((Object)BuiltinDimensionTypes.NETHER_EFFECTS, (Object)new NetherEffects());
        p_108881_.put((Object)BuiltinDimensionTypes.END_EFFECTS, (Object)new EndEffects());
    });
    private final float[] sunriseCol = new float[4];
    private final float cloudLevel;
    private final boolean hasGround;
    private final SkyType skyType;
    private final boolean forceBrightLightmap;
    private final boolean constantAmbientLight;

    public DimensionSpecialEffects(float p_108866_, boolean p_108867_, SkyType p_108868_, boolean p_108869_, boolean p_108870_) {
        this.cloudLevel = p_108866_;
        this.hasGround = p_108867_;
        this.skyType = p_108868_;
        this.forceBrightLightmap = p_108869_;
        this.constantAmbientLight = p_108870_;
    }

    public static DimensionSpecialEffects forType(DimensionType p_108877_) {
        return (DimensionSpecialEffects)EFFECTS.get((Object)p_108877_.effectsLocation());
    }

    @Nullable
    public float[] getSunriseColor(float p_108872_, float p_108873_) {
        float $$2 = 0.4f;
        float $$3 = Mth.cos(p_108872_ * ((float)Math.PI * 2)) - 0.0f;
        float $$4 = -0.0f;
        if ($$3 >= -0.4f && $$3 <= 0.4f) {
            float $$5 = ($$3 - -0.0f) / 0.4f * 0.5f + 0.5f;
            float $$6 = 1.0f - (1.0f - Mth.sin($$5 * (float)Math.PI)) * 0.99f;
            $$6 *= $$6;
            this.sunriseCol[0] = $$5 * 0.3f + 0.7f;
            this.sunriseCol[1] = $$5 * $$5 * 0.7f + 0.2f;
            this.sunriseCol[2] = $$5 * $$5 * 0.0f + 0.2f;
            this.sunriseCol[3] = $$6;
            return this.sunriseCol;
        }
        return null;
    }

    public float getCloudHeight() {
        return this.cloudLevel;
    }

    public boolean hasGround() {
        return this.hasGround;
    }

    public abstract Vec3 getBrightnessDependentFogColor(Vec3 var1, float var2);

    public abstract boolean isFoggyAt(int var1, int var2);

    public SkyType skyType() {
        return this.skyType;
    }

    public boolean forceBrightLightmap() {
        return this.forceBrightLightmap;
    }

    public boolean constantAmbientLight() {
        return this.constantAmbientLight;
    }

    public static enum SkyType {
        NONE,
        NORMAL,
        END;

    }

    public static class OverworldEffects
    extends DimensionSpecialEffects {
        public static final int CLOUD_LEVEL = 192;

        public OverworldEffects() {
            super(192.0f, true, SkyType.NORMAL, false, false);
        }

        @Override
        public Vec3 getBrightnessDependentFogColor(Vec3 p_108908_, float p_108909_) {
            return p_108908_.multiply(p_108909_ * 0.94f + 0.06f, p_108909_ * 0.94f + 0.06f, p_108909_ * 0.91f + 0.09f);
        }

        @Override
        public boolean isFoggyAt(int p_108905_, int p_108906_) {
            return false;
        }
    }

    public static class NetherEffects
    extends DimensionSpecialEffects {
        public NetherEffects() {
            super(Float.NaN, true, SkyType.NONE, false, true);
        }

        @Override
        public Vec3 getBrightnessDependentFogColor(Vec3 p_108901_, float p_108902_) {
            return p_108901_;
        }

        @Override
        public boolean isFoggyAt(int p_108898_, int p_108899_) {
            return true;
        }
    }

    public static class EndEffects
    extends DimensionSpecialEffects {
        public EndEffects() {
            super(Float.NaN, false, SkyType.END, true, false);
        }

        @Override
        public Vec3 getBrightnessDependentFogColor(Vec3 p_108894_, float p_108895_) {
            return p_108894_.scale(0.15f);
        }

        @Override
        public boolean isFoggyAt(int p_108891_, int p_108892_) {
            return false;
        }

        @Override
        @Nullable
        public float[] getSunriseColor(float p_108888_, float p_108889_) {
            return null;
        }
    }
}

