/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class SpellParticle
extends TextureSheetParticle {
    private static final RandomSource RANDOM = RandomSource.create();
    private final SpriteSet sprites;
    private float originalAlpha = 1.0f;

    SpellParticle(ClientLevel p_107762_, double p_107763_, double p_107764_, double p_107765_, double p_107766_, double p_107767_, double p_107768_, SpriteSet p_107769_) {
        super(p_107762_, p_107763_, p_107764_, p_107765_, 0.5 - RANDOM.nextDouble(), p_107767_, 0.5 - RANDOM.nextDouble());
        this.friction = 0.96f;
        this.gravity = -0.1f;
        this.speedUpWhenYMotionIsBlocked = true;
        this.sprites = p_107769_;
        this.yd *= (double)0.2f;
        if (p_107766_ == 0.0 && p_107768_ == 0.0) {
            this.xd *= (double)0.1f;
            this.zd *= (double)0.1f;
        }
        this.quadSize *= 0.75f;
        this.lifetime = (int)(8.0 / (Math.random() * 0.8 + 0.2));
        this.hasPhysics = false;
        this.setSpriteFromAge(p_107769_);
        if (this.isCloseToScopingPlayer()) {
            this.setAlpha(0.0f);
        }
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @Override
    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
        this.alpha = this.isCloseToScopingPlayer() ? 0.0f : Mth.lerp(0.05f, this.alpha, this.originalAlpha);
    }

    @Override
    protected void setAlpha(float p_340807_) {
        super.setAlpha(p_340807_);
        this.originalAlpha = p_340807_;
    }

    private boolean isCloseToScopingPlayer() {
        Minecraft $$0 = Minecraft.getInstance();
        LocalPlayer $$1 = $$0.player;
        return $$1 != null && $$1.getEyePosition().distanceToSqr(this.x, this.y, this.z) <= 9.0 && $$0.options.getCameraType().isFirstPerson() && $$1.isScoping();
    }

    public static class InstantProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public InstantProvider(SpriteSet p_107805_) {
            this.sprite = p_107805_;
        }

        @Override
        public Particle createParticle(SimpleParticleType p_107816_, ClientLevel p_107817_, double p_107818_, double p_107819_, double p_107820_, double p_107821_, double p_107822_, double p_107823_) {
            return new SpellParticle(p_107817_, p_107818_, p_107819_, p_107820_, p_107821_, p_107822_, p_107823_, this.sprite);
        }

        @Override
        public /* synthetic */ Particle createParticle(ParticleOptions particleOptions, ClientLevel clientLevel, double d, double d2, double d3, double d4, double d5, double d6) {
            return this.createParticle((SimpleParticleType)particleOptions, clientLevel, d, d2, d3, d4, d5, d6);
        }
    }

    public static class WitchProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public WitchProvider(SpriteSet p_107868_) {
            this.sprite = p_107868_;
        }

        @Override
        public Particle createParticle(SimpleParticleType p_107879_, ClientLevel p_107880_, double p_107881_, double p_107882_, double p_107883_, double p_107884_, double p_107885_, double p_107886_) {
            SpellParticle $$8 = new SpellParticle(p_107880_, p_107881_, p_107882_, p_107883_, p_107884_, p_107885_, p_107886_, this.sprite);
            float $$9 = p_107880_.random.nextFloat() * 0.5f + 0.35f;
            $$8.setColor(1.0f * $$9, 0.0f * $$9, 1.0f * $$9);
            return $$8;
        }

        @Override
        public /* synthetic */ Particle createParticle(ParticleOptions particleOptions, ClientLevel clientLevel, double d, double d2, double d3, double d4, double d5, double d6) {
            return this.createParticle((SimpleParticleType)particleOptions, clientLevel, d, d2, d3, d4, d5, d6);
        }
    }

    public static class MobEffectProvider
    implements ParticleProvider<ColorParticleOption> {
        private final SpriteSet sprite;

        public MobEffectProvider(SpriteSet p_333733_) {
            this.sprite = p_333733_;
        }

        @Override
        public Particle createParticle(ColorParticleOption p_333710_, ClientLevel p_333861_, double p_333927_, double p_333732_, double p_333727_, double p_334019_, double p_333790_, double p_333937_) {
            SpellParticle $$8 = new SpellParticle(p_333861_, p_333927_, p_333732_, p_333727_, p_334019_, p_333790_, p_333937_, this.sprite);
            $$8.setColor(p_333710_.getRed(), p_333710_.getGreen(), p_333710_.getBlue());
            ((Particle)$$8).setAlpha(p_333710_.getAlpha());
            return $$8;
        }

        @Override
        public /* synthetic */ Particle createParticle(ParticleOptions particleOptions, ClientLevel clientLevel, double d, double d2, double d3, double d4, double d5, double d6) {
            return this.createParticle((ColorParticleOption)particleOptions, clientLevel, d, d2, d3, d4, d5, d6);
        }
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Provider(SpriteSet p_107847_) {
            this.sprite = p_107847_;
        }

        @Override
        public Particle createParticle(SimpleParticleType p_107858_, ClientLevel p_107859_, double p_107860_, double p_107861_, double p_107862_, double p_107863_, double p_107864_, double p_107865_) {
            return new SpellParticle(p_107859_, p_107860_, p_107861_, p_107862_, p_107863_, p_107864_, p_107865_, this.sprite);
        }

        @Override
        public /* synthetic */ Particle createParticle(ParticleOptions particleOptions, ClientLevel clientLevel, double d, double d2, double d3, double d4, double d5, double d6) {
            return this.createParticle((SimpleParticleType)particleOptions, clientLevel, d, d2, d3, d4, d5, d6);
        }
    }
}

