/*
 * Decompiled with CFR 0.152.
 */
package io.github.zekerzhayard.forgewrapper.installer.detector;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import cpw.mods.modlauncher.Launcher;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface IFileDetector {
    public String name();

    public boolean enabled(HashMap<String, IFileDetector> var1);

    default public Path getLibraryDir() {
        String libraryDir = System.getProperty("forgewrapper.librariesDir");
        if (libraryDir != null) {
            return Paths.get(libraryDir, new String[0]).toAbsolutePath();
        }
        try {
            Path launcher = Paths.get(Launcher.class.getProtectionDomain().getCodeSource().getLocation().toURI()).toAbsolutePath();
            return launcher.getParent().getParent().getParent().getParent().getParent().toAbsolutePath();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    default public Path getInstallerJar(String forgeGroup, String forgeArtifact, String forgeFullVersion) {
        String installer = System.getProperty("forgewrapper.installer");
        if (installer != null) {
            return Paths.get(installer, new String[0]).toAbsolutePath();
        }
        return null;
    }

    default public Path getMinecraftJar(String mcVersion) {
        String minecraft = System.getProperty("forgewrapper.minecraft");
        if (minecraft != null) {
            return Paths.get(minecraft, new String[0]).toAbsolutePath();
        }
        return null;
    }

    default public List<String> getJvmArgs(String forgeGroup, String forgeArtifact, String forgeFullVersion) {
        return this.getDataFromInstaller(forgeGroup, forgeArtifact, forgeFullVersion, "version.json", e -> {
            JsonElement element = e.getAsJsonObject().get("arguments").getAsJsonObject().get("jvm");
            ArrayList args = new ArrayList();
            if (!element.equals(JsonNull.INSTANCE)) {
                element.getAsJsonArray().iterator().forEachRemaining(je -> args.add(je.getAsString()));
            }
            return args;
        });
    }

    default public List<String> getExtraLibraries(String forgeGroup, String forgeArtifact, String forgeFullVersion) {
        return this.getDataFromInstaller(forgeGroup, forgeArtifact, forgeFullVersion, "version.json", e -> {
            ArrayList paths = new ArrayList();
            e.getAsJsonObject().getAsJsonArray("libraries").iterator().forEachRemaining(je -> {
                JsonObject artifact = je.getAsJsonObject().get("downloads").getAsJsonObject().get("artifact").getAsJsonObject();
                if (artifact.get("url").getAsString().isEmpty()) {
                    paths.add(artifact.get("path").getAsString());
                }
            });
            return paths;
        });
    }

    default public String getMainClass(String forgeGroup, String forgeArtifact, String forgeFullVersion) {
        return this.getDataFromInstaller(forgeGroup, forgeArtifact, forgeFullVersion, "version.json", e -> e.getAsJsonObject().getAsJsonPrimitive("mainClass").getAsString());
    }

    default public JsonObject getInstallProfileExtraData(String forgeGroup, String forgeArtifact, String forgeFullVersion) {
        return this.getDataFromInstaller(forgeGroup, forgeArtifact, forgeFullVersion, "install_profile.json", e -> e.getAsJsonObject().getAsJsonObject("data"));
    }

    /*
     * Exception decompiling
     */
    default public <R> R getDataFromInstaller(String forgeGroup, String forgeArtifact, String forgeFullVersion, String entry, Function<JsonElement, R> function) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    default public boolean checkExtraFiles(String forgeGroup, String forgeArtifact, String forgeFullVersion) {
        JsonObject jo = this.getInstallProfileExtraData(forgeGroup, forgeArtifact, forgeFullVersion);
        if (jo != null) {
            HashMap<String, Path> libsMap = new HashMap<String, Path>();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Pattern artifactPattern = Pattern.compile("^\\[(?<groupId>[^:]*):(?<artifactId>[^:]*):(?<version>[^:@]*)(:(?<classifier>[^@]*))?(@(?<type>[^]]*))?]$");
            for (Map.Entry entry : jo.entrySet()) {
                String clientStr = ((JsonElement)entry.getValue()).getAsJsonObject().get("client").getAsString();
                if (((String)entry.getKey()).endsWith("_SHA")) {
                    Pattern p = Pattern.compile("^'(?<sha1>[A-Za-z0-9]{40})'$");
                    Matcher m = p.matcher(clientStr);
                    if (!m.find()) continue;
                    hashMap.put((String)entry.getKey(), m.group("sha1"));
                    continue;
                }
                Matcher m = artifactPattern.matcher(clientStr);
                if (!m.find()) continue;
                String groupId = IFileDetector.nullToDefault(m.group("groupId"), "");
                String artifactId = IFileDetector.nullToDefault(m.group("artifactId"), "");
                String version = IFileDetector.nullToDefault(m.group("version"), "");
                String classifier = IFileDetector.nullToDefault(m.group("classifier"), "");
                String type = IFileDetector.nullToDefault(m.group("type"), "jar");
                libsMap.put((String)entry.getKey(), this.getLibraryDir().resolve(groupId.replace('.', File.separatorChar)).resolve(artifactId).resolve(version).resolve(artifactId + "-" + version + (classifier.isEmpty() ? "" : "-") + classifier + "." + type).toAbsolutePath());
            }
            boolean checked = true;
            for (Map.Entry entry : libsMap.entrySet()) {
                String sha1 = "";
                String entryKey = (String)entry.getKey();
                if (entryKey.equals("MC_UNPACKED")) continue;
                System.out.println("Checking: " + entryKey);
                if (!entryKey.equals("PATCHED")) {
                    sha1 = (String)hashMap.get(entryKey + "_SHA");
                }
                if (checked = IFileDetector.checkExtraFile((Path)entry.getValue(), sha1)) continue;
                System.out.println("Missing: " + entry.getValue());
                break;
            }
            return checked;
        }
        return true;
    }

    public static boolean checkExtraFile(Path path, String sha1) {
        if (!IFileDetector.isFile(path)) {
            return false;
        }
        if (sha1 == null || sha1.equals("")) {
            return true;
        }
        return sha1.toLowerCase(Locale.ENGLISH).equals(IFileDetector.getFileSHA1(path));
    }

    public static boolean isFile(Path path) {
        return path != null && Files.isRegularFile(path, new LinkOption[0]);
    }

    public static String getFileSHA1(Path path) {
        try {
            StringBuilder sha1 = new StringBuilder(new BigInteger(1, MessageDigest.getInstance("SHA-1").digest(Files.readAllBytes(path))).toString(16));
            while (sha1.length() < 40) {
                sha1.insert(0, "0");
            }
            return sha1.toString().toLowerCase(Locale.ENGLISH);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String nullToDefault(String string, String defaultValue) {
        return string == null ? defaultValue : string;
    }
}

