/*
 * Decompiled with CFR 0.152.
 */
package io.github.zekerzhayard.forgewrapper.installer;

import cpw.mods.modlauncher.Launcher;
import io.github.zekerzhayard.forgewrapper.installer.Bootstrap;
import io.github.zekerzhayard.forgewrapper.installer.detector.DetectorLoader;
import io.github.zekerzhayard.forgewrapper.installer.detector.IFileDetector;
import io.github.zekerzhayard.forgewrapper.installer.util.ModuleUtil;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Main {
    public static void main(String[] args) throws Throwable {
        List argsList = Stream.of(args).collect(Collectors.toList());
        boolean isNeoForge = argsList.contains("--fml.neoForgeVersion");
        String mcVersion = (String)argsList.get(argsList.indexOf("--fml.mcVersion") + 1);
        String forgeGroup = argsList.contains("--fml.forgeGroup") ? (String)argsList.get(argsList.indexOf("--fml.forgeGroup") + 1) : "net.neoforged";
        String forgeArtifact = isNeoForge ? "neoforge" : "forge";
        String forgeVersionKey = isNeoForge ? "--fml.neoForgeVersion" : "--fml.forgeVersion";
        String forgeVersion = (String)argsList.get(argsList.indexOf(forgeVersionKey) + 1);
        String forgeFullVersion = isNeoForge ? forgeVersion : mcVersion + "-" + forgeVersion;
        IFileDetector detector = DetectorLoader.loadDetector();
        try {
            Bootstrap.bootstrap(detector.getJvmArgs(forgeGroup, forgeArtifact, forgeFullVersion), detector.getMinecraftJar(mcVersion).getFileName().toString(), detector.getLibraryDir().toAbsolutePath().toString());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!detector.checkExtraFiles(forgeGroup, forgeArtifact, forgeFullVersion)) {
            System.out.println("Some extra libraries are missing! Running the installer to generate them now.");
            Path installerJar = detector.getInstallerJar(forgeGroup, forgeArtifact, forgeFullVersion);
            if (!IFileDetector.isFile(installerJar)) {
                throw new RuntimeException("Unable to detect the forge installer!");
            }
            Path minecraftJar = detector.getMinecraftJar(mcVersion);
            if (!IFileDetector.isFile(minecraftJar)) {
                throw new RuntimeException("Unable to detect the Minecraft jar!");
            }
            try (URLClassLoader ucl = URLClassLoader.newInstance(new URL[]{Main.class.getProtectionDomain().getCodeSource().getLocation(), Launcher.class.getProtectionDomain().getCodeSource().getLocation(), installerJar.toUri().toURL()}, ModuleUtil.getPlatformClassLoader());){
                Class<?> installer = ucl.loadClass("io.github.zekerzhayard.forgewrapper.installer.Installer");
                if (!((Boolean)installer.getMethod("install", File.class, File.class, File.class).invoke(null, detector.getLibraryDir().toFile(), minecraftJar.toFile(), installerJar.toFile())).booleanValue()) {
                    return;
                }
            }
        }
        ModuleUtil.setupClassPath(detector.getLibraryDir(), detector.getExtraLibraries(forgeGroup, forgeArtifact, forgeFullVersion));
        Class<?> mainClass = ModuleUtil.setupBootstrapLauncher(Class.forName(detector.getMainClass(forgeGroup, forgeArtifact, forgeFullVersion)));
        mainClass.getMethod("main", String[].class).invoke(null, new Object[]{args});
    }
}

