/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.cl;

import cpw.mods.cl.JarModuleFinder;
import cpw.mods.cl.ModularURLHandler;
import cpw.mods.cl.ProtectionDomainHelper;
import cpw.mods.util.LambdaExceptionUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.module.Configuration;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.NoSuchFileException;
import java.security.CodeSource;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class ModuleClassLoader
extends ClassLoader {
    private static final MethodHandle LAYER_BIND_TO_LOADER;
    private final Configuration configuration;
    private final Map<String, JarModuleFinder.JarModuleReference> resolvedRoots;
    private final Map<String, ResolvedModule> packageLookup;
    private final Map<String, ClassLoader> parentLoaders;
    private ClassLoader fallbackClassLoader = ClassLoader.getPlatformClassLoader();
    private static final ClassLoader systemClassLoader;

    private static void bindToLayer(ModuleClassLoader classLoader, ModuleLayer layer) {
        try {
            LAYER_BIND_TO_LOADER.invokeExact(layer, classLoader);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public ModuleClassLoader(String name, Configuration configuration, List<ModuleLayer> parentLayers) {
        this(name, configuration, parentLayers, null);
    }

    @VisibleForTesting
    public ModuleClassLoader(String name, Configuration configuration, List<ModuleLayer> parentLayers, @Nullable ClassLoader parentLoader) {
        super(name, parentLoader);
        this.fallbackClassLoader = Objects.requireNonNullElse(parentLoader, ClassLoader.getPlatformClassLoader());
        this.configuration = configuration;
        this.packageLookup = new HashMap<String, ResolvedModule>();
        this.resolvedRoots = configuration.modules().stream().filter(m -> m.reference() instanceof JarModuleFinder.JarModuleReference).peek(mod -> mod.reference().descriptor().packages().forEach(pk -> this.packageLookup.put((String)pk, (ResolvedModule)mod))).collect(Collectors.toMap(mod -> mod.reference().descriptor().name(), mod -> (JarModuleFinder.JarModuleReference)mod.reference()));
        this.parentLoaders = new HashMap<String, ClassLoader>();
        HashSet<ModuleDescriptor> processedAutomaticDescriptors = new HashSet<ModuleDescriptor>();
        HashMap<ResolvedModule, ClassLoader> classLoaderMap = new HashMap<ResolvedModule, ClassLoader>();
        Function<ResolvedModule, ClassLoader> findClassLoader = k -> {
            if (!this.resolvedRoots.containsKey(k.name())) {
                return parentLayers.stream().filter(l -> l.configuration() == k.configuration()).flatMap(layer -> Optional.ofNullable(layer.findLoader(k.name())).stream()).findFirst().orElse(ClassLoader.getPlatformClassLoader());
            }
            return this;
        };
        for (ResolvedModule rm : configuration.modules()) {
            for (ResolvedModule other : rm.reads()) {
                ClassLoader cl = classLoaderMap.computeIfAbsent(other, findClassLoader);
                ModuleDescriptor descriptor = other.reference().descriptor();
                if (descriptor.isAutomatic()) {
                    if (!processedAutomaticDescriptors.add(descriptor)) continue;
                    descriptor.packages().forEach(pn -> this.parentLoaders.put((String)pn, cl));
                    continue;
                }
                descriptor.exports().stream().filter(e -> !e.isQualified() || e.isQualified() && other.configuration() == configuration && e.targets().contains(rm.name())).map(ModuleDescriptor.Exports::source).forEach(pn -> this.parentLoaders.put((String)pn, cl));
            }
        }
        HashSet visitedLayers = new HashSet();
        parentLayers.forEach(p -> ModuleClassLoader.forLayerAndParents(p, visitedLayers, l -> ModuleClassLoader.bindToLayer(this, l)));
    }

    private static void forLayerAndParents(ModuleLayer layer, Set<ModuleLayer> visited, Consumer<ModuleLayer> operation) {
        if (visited.contains(layer)) {
            return;
        }
        visited.add(layer);
        operation.accept(layer);
        if (layer != ModuleLayer.boot()) {
            layer.parents().forEach(l -> ModuleClassLoader.forLayerAndParents(l, visited, operation));
        }
    }

    private URL readerToURL(ModuleReader reader, ModuleReference ref, String name) {
        try {
            return ModuleClassLoader.toURL(reader.find(name));
        }
        catch (IOException e) {
            return null;
        }
    }

    private static URL toURL(Optional<URI> uri) {
        if (uri.isPresent()) {
            try {
                return uri.get().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return null;
    }

    private static Stream<InputStream> closeHandler(Optional<InputStream> supplier) {
        InputStream is = supplier.orElse(null);
        return (Stream)Optional.ofNullable(is).stream().onClose(() -> Optional.ofNullable(is).ifPresent(LambdaExceptionUtils.rethrowConsumer(InputStream::close)));
    }

    protected byte[] getClassBytes(ModuleReader reader, ModuleReference ref, String name) {
        String cname = name.replace('.', '/') + ".class";
        try (Stream<InputStream> istream = ModuleClassLoader.closeHandler(Optional.of(reader).flatMap(LambdaExceptionUtils.rethrowFunction(r -> r.open(cname))));){
            byte[] byArray = istream.map(LambdaExceptionUtils.rethrowFunction(InputStream::readAllBytes)).findFirst().orElseGet(() -> new byte[0]);
            return byArray;
        }
    }

    private Class<?> readerToClass(ModuleReader reader, ModuleReference ref, String name) {
        byte[] bytes = this.maybeTransformClassBytes(this.getClassBytes(reader, ref, name), name, null);
        if (bytes.length == 0) {
            return null;
        }
        String cname = name.replace('.', '/') + ".class";
        JarModuleFinder.JarModuleReference modroot = this.resolvedRoots.get(ref.descriptor().name());
        ProtectionDomainHelper.tryDefinePackage(this, name, modroot.jar().getManifest(), t -> modroot.jar().getManifest().getAttributes((String)t), this::definePackage);
        CodeSource cs = ProtectionDomainHelper.createCodeSource(ModuleClassLoader.toURL(ref.location()), modroot.jar().verifyAndGetSigners(cname, bytes));
        Class<?> cls = this.defineClass(name, bytes, 0, bytes.length, ProtectionDomainHelper.createProtectionDomain(cs, this));
        ProtectionDomainHelper.trySetPackageModule(cls.getPackage(), cls.getModule());
        return cls;
    }

    protected byte[] maybeTransformClassBytes(byte[] bytes, String name, String context) {
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            int index;
            Class<?> c = this.findLoadedClass(name);
            if (c == null && (index = name.lastIndexOf(46)) >= 0) {
                String pname = name.substring(0, index);
                c = this.packageLookup.containsKey(pname) ? this.findClass(this.packageLookup.get(pname).name(), name) : (name.contains("pro.gravit.launcher") || name.contains("pro.gravit.utils") ? systemClassLoader.loadClass(name) : this.parentLoaders.getOrDefault(pname, this.fallbackClassLoader).loadClass(name));
            }
            if (c == null) {
                throw new ClassNotFoundException(name);
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String mname = this.classNameToModuleName(name);
        if (mname != null) {
            return this.findClass(mname, name);
        }
        return super.findClass(name);
    }

    protected String classNameToModuleName(String name) {
        String pname = name.substring(0, name.lastIndexOf(46));
        return Optional.ofNullable(this.packageLookup.get(pname)).map(ResolvedModule::name).orElse(null);
    }

    private Package definePackage(String[] args) {
        return this.definePackage(args[0], args[1], args[2], args[3], args[4], args[5], args[6], null);
    }

    @Override
    public URL getResource(String name) {
        try {
            List<URL> reslist = this.findResourceList(name);
            if (!reslist.isEmpty()) {
                return reslist.get(0);
            }
            return this.fallbackClassLoader.getResource(name);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected URL findResource(String moduleName, String name) throws IOException {
        try {
            return this.loadFromModule(moduleName, (reader, ref) -> this.readerToURL((ModuleReader)reader, (ModuleReference)ref, name));
        }
        catch (UncheckedIOException ioe) {
            throw ioe.getCause();
        }
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return Collections.enumeration(this.findResourceList(name));
    }

    private List<URL> findResourceList(String name) throws IOException {
        int idx = name.lastIndexOf(47);
        String pkgname = idx == -1 || idx == name.length() - 1 ? "" : name.substring(0, idx).replace('/', '.');
        ResolvedModule module = this.packageLookup.get(pkgname);
        if (module != null) {
            URL res = this.findResource(module.name(), name);
            return res != null ? List.of(res) : List.of();
        }
        return this.resolvedRoots.values().stream().map(JarModuleFinder.JarModuleReference::jar).map(jar -> jar.findFile(name)).map(ModuleClassLoader::toURL).filter(Objects::nonNull).toList();
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        return Collections.enumeration(this.findResourceList(name));
    }

    @Override
    protected Class<?> findClass(String moduleName, String name) {
        try {
            return this.loadFromModule(moduleName, (reader, ref) -> this.readerToClass((ModuleReader)reader, (ModuleReference)ref, name));
        }
        catch (IOException e) {
            return null;
        }
    }

    protected <T> T loadFromModule(String moduleName, BiFunction<ModuleReader, ModuleReference, T> lookup) throws IOException {
        Optional<ResolvedModule> module = this.configuration.findModule(moduleName);
        if (module.isEmpty()) {
            throw new NoSuchFileException("module " + moduleName);
        }
        ModuleReference ref = module.get().reference();
        try (ModuleReader reader = ref.open();){
            T t = lookup.apply(reader, ref);
            return t;
        }
    }

    protected byte[] getMaybeTransformedClassBytes(String name, String context) throws ClassNotFoundException {
        IOException suppressed;
        byte[] bytes;
        block12: {
            bytes = new byte[]{};
            suppressed = null;
            try {
                String pname = name.substring(0, name.lastIndexOf(46));
                if (this.packageLookup.containsKey(pname)) {
                    bytes = this.loadFromModule(this.classNameToModuleName(name), (reader, ref) -> this.getClassBytes((ModuleReader)reader, (ModuleReference)ref, name));
                    break block12;
                }
                if (!this.parentLoaders.containsKey(pname)) break block12;
                String cname = name.replace('.', '/') + ".class";
                try (InputStream is = this.parentLoaders.get(pname).getResourceAsStream(cname);){
                    if (is != null) {
                        bytes = is.readAllBytes();
                    }
                }
            }
            catch (IOException e) {
                suppressed = e;
            }
        }
        byte[] maybeTransformedBytes = this.maybeTransformClassBytes(bytes, name, context);
        if (maybeTransformedBytes.length == 0) {
            ClassNotFoundException e = new ClassNotFoundException(name);
            if (suppressed != null) {
                e.addSuppressed(suppressed);
            }
            throw e;
        }
        return maybeTransformedBytes;
    }

    public void setFallbackClassLoader(ClassLoader fallbackClassLoader) {
        this.fallbackClassLoader = fallbackClassLoader;
    }

    static {
        ClassLoader.registerAsParallelCapable();
        URL.setURLStreamHandlerFactory(ModularURLHandler.INSTANCE);
        ModularURLHandler.initFrom(ModuleClassLoader.class.getModule().getLayer());
        try {
            Field hackfield = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            hackfield.setAccessible(true);
            MethodHandles.Lookup hack = (MethodHandles.Lookup)hackfield.get(null);
            LAYER_BIND_TO_LOADER = hack.findSpecial(ModuleLayer.class, "bindToLoader", MethodType.methodType(Void.TYPE, ClassLoader.class), ModuleLayer.class);
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        systemClassLoader = ClassLoader.getSystemClassLoader();
    }
}

