/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import com.mojang.authlib.Environment;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.yggdrasil.ServicesKeyInfo;
import com.mojang.authlib.yggdrasil.ServicesKeySet;
import com.mojang.authlib.yggdrasil.YggdrasilGameProfileRepository;
import com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilServicesKeyInfo;
import com.mojang.authlib.yggdrasil.YggdrasilUserApiService;
import java.net.Proxy;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.List;

public class YggdrasilAuthenticationService
extends HttpAuthenticationService {
    private Proxy proxy;
    private String clientToken;
    private Environment environment;
    private ServicesKeySet servicesKey;

    public YggdrasilAuthenticationService(Proxy proxy) {
        super(proxy);
        this.proxy = proxy;
        this.servicesKey = this.makeNullServicesKeySet();
    }

    public YggdrasilAuthenticationService(Proxy proxy, Environment environment) {
        super(proxy);
        this.proxy = proxy;
        this.environment = environment;
        this.servicesKey = this.makeNullServicesKeySet();
    }

    public YggdrasilAuthenticationService(Proxy proxy, String clientToken) {
        super(proxy);
        this.proxy = proxy;
        this.clientToken = clientToken;
        this.servicesKey = this.makeNullServicesKeySet();
    }

    public YggdrasilAuthenticationService(Proxy proxy, String clientToken, Environment environment) {
        super(proxy);
        this.proxy = proxy;
        this.clientToken = clientToken;
        this.environment = environment;
        this.servicesKey = this.makeNullServicesKeySet();
    }

    private ServicesKeySet makeNullServicesKeySet() {
        KeyPair pair;
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            pair = generator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        ServicesKeyInfo keyInfo = YggdrasilServicesKeyInfo.parse(pair.getPublic().getEncoded());
        return type -> List.of(keyInfo);
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public ServicesKeySet getServicesKeySet() {
        return this.servicesKey;
    }

    @Override
    public MinecraftSessionService createMinecraftSessionService() {
        return new YggdrasilMinecraftSessionService(this, this.environment);
    }

    @Override
    public GameProfileRepository createProfileRepository() {
        return new YggdrasilGameProfileRepository(this, this.environment);
    }

    public UserApiService createUserApiService(String accessToken) throws AuthenticationException {
        return new YggdrasilUserApiService(accessToken, this.getProxy(), this.environment);
    }

    @Override
    public Proxy getProxy() {
        return this.proxy;
    }
}

